/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;

public abstract class ImmutableUserMap {
    public static final ImmutableUserMap EMPTY = new ImmutableUserMap(){

        @Override
        public <T> T get(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ImmutableUserMap$1.get must not be null");
            }
            return null;
        }
    };

    private ImmutableUserMap() {
    }

    public abstract <T> T get(@NotNull Key<T> var1);

    public final <T> ImmutableUserMap put(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ImmutableUserMap.put must not be null");
        }
        return new ImmutableUserMapImpl(key, value, this);
    }

    private static class ImmutableUserMapImpl<V>
    extends ImmutableUserMap {
        private final Key<V> myKey;
        private final V myValue;
        private final ImmutableUserMap myNext;

        private ImmutableUserMapImpl(Key<V> key, V value, ImmutableUserMap next) {
            this.myKey = key;
            this.myNext = next;
            this.myValue = value;
        }

        @Override
        public <T> T get(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ImmutableUserMap$ImmutableUserMapImpl.get must not be null");
            }
            if (key.equals(this.myKey)) {
                return (T)this.myValue;
            }
            return this.myNext.get(key);
        }
    }
}

