/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class DistinctRootsCollection<T>
implements Collection<T> {
    private final Collection<T> myCollection = new ArrayList<T>();

    protected abstract boolean isAncestor(@NotNull T var1, @NotNull T var2);

    public DistinctRootsCollection() {
    }

    public DistinctRootsCollection(Collection<T> collection) {
        this.addAll((Collection<? extends T>)collection);
    }

    public DistinctRootsCollection(T[] collection) {
        this(Arrays.asList(collection));
    }

    @Override
    public int size() {
        return this.myCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myCollection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myCollection.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.myCollection.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.myCollection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.myCollection.toArray(a);
    }

    @Override
    public boolean add(T o) {
        ArrayList<T> toRemove = new ArrayList<T>();
        for (T existing : this.myCollection) {
            if (this.isAncestor(existing, o)) {
                return false;
            }
            if (!this.isAncestor(o, existing)) continue;
            toRemove.add(existing);
        }
        this.myCollection.removeAll(toRemove);
        this.myCollection.add(o);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.myCollection.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myCollection.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T t : c) {
            changed |= this.add(t);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.myCollection.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.myCollection.retainAll(c);
    }

    @Override
    public void clear() {
        this.myCollection.clear();
    }
}

