/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Condition;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Factory;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.util.ArrayFactory;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.NullableFunction;
import org.jetbrains.jet.internal.com.intellij.util.PairProcessor;
import org.jetbrains.jet.internal.com.intellij.util.Processor;
import org.jetbrains.jet.internal.com.intellij.util.containers.Convertor;
import org.jetbrains.jet.internal.com.intellij.util.containers.EmptyIterable;
import org.jetbrains.jet.internal.com.intellij.util.containers.EmptyIterator;
import org.jetbrains.jet.internal.com.intellij.util.containers.FilteringIterator;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashSet;
import org.jetbrains.jet.internal.com.intellij.util.containers.SequenceIterator;
import org.jetbrains.jet.internal.gnu.trove.THashMap;
import org.jetbrains.jet.internal.gnu.trove.TIntArrayList;
import org.jetbrains.jet.internal.gnu.trove.TObjectHashingStrategy;

public class ContainerUtil {
    public static <K, V> Map<K, V> intersection(Map<K, V> map1, Map<K, V> map2) {
        HashMap res = new HashMap();
        HashSet<K> keys = new HashSet<K>();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        for (Object k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (v1 != (v2 = map2.get(k)) && (v1 == null || !v1.equals(v2))) continue;
            res.put(k, v1);
        }
        return res;
    }

    public static <K, V> Map<K, Pair<V, V>> diff(Map<K, V> map1, Map<K, V> map2) {
        HashMap res = new HashMap();
        HashSet<K> keys = new HashSet<K>();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        for (Object k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (v1 == (v2 = map2.get(k)) || v1 != null && v1.equals(v2)) continue;
            res.put(k, Pair.create(v1, v2));
        }
        return res;
    }

    @NotNull
    public static <T> List<T> mergeSortedLists(@NotNull List<T> list1, @NotNull List<T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems) {
        if (list1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mergeSortedLists must not be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mergeSortedLists must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mergeSortedLists must not be null");
        }
        ArrayList<T> result = new ArrayList<T>(list1.size() + list2.size());
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            T element2;
            if (index1 >= list1.size()) {
                result.add(list2.get(index2++));
                continue;
            }
            if (index2 >= list2.size()) {
                result.add(list1.get(index1++));
                continue;
            }
            T element1 = list1.get(index1);
            int c = comparator.compare(element1, element2 = list2.get(index2));
            if (c < 0) {
                result.add(element1);
                ++index1;
                continue;
            }
            if (c > 0) {
                result.add(element2);
                ++index2;
                continue;
            }
            result.add(element1);
            if (!mergeEqualItems) {
                result.add(element2);
            }
            ++index1;
            ++index2;
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.mergeSortedLists must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> mergeSortedArrays(@NotNull T[] list1, @NotNull T[] list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems, @Nullable Processor<? super T> filter) {
        if (list1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mergeSortedArrays must not be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mergeSortedArrays must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mergeSortedArrays must not be null");
        }
        int index1 = 0;
        int index2 = 0;
        ArrayList<T> result = new ArrayList<T>(list1.length + list2.length);
        while (index1 < list1.length || index2 < list2.length) {
            T t;
            if (index1 >= list1.length) {
                t = list2[index2++];
                if (filter != null && !filter.process(t)) continue;
                result.add(t);
                continue;
            }
            if (index2 >= list2.length) {
                t = list1[index1++];
                if (filter != null && !filter.process(t)) continue;
                result.add(t);
                continue;
            }
            T element1 = list1[index1];
            if (filter != null && !filter.process(element1)) {
                ++index1;
                continue;
            }
            T element2 = list2[index2];
            if (filter != null && !filter.process(element2)) {
                ++index2;
                continue;
            }
            int c = comparator.compare(element1, element2);
            if (c < 0) {
                result.add(element1);
                ++index1;
                continue;
            }
            if (c > 0) {
                result.add(element2);
                ++index2;
                continue;
            }
            result.add(element1);
            if (!mergeEqualItems) {
                result.add(element2);
            }
            ++index1;
            ++index2;
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.mergeSortedArrays must not return null");
        }
        return arrayList;
    }

    public static <T> List<T> subList(List<T> list, int from) {
        return list.subList(from, list.size());
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        if (appendix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> iterator) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        while (iterator.hasNext()) {
            T o = iterator.next();
            collection.add(o);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<T> iterator) {
        List list;
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.collect must not be null");
        }
        if (!iterator.hasNext()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.collect must not return null");
            return list;
        }
        ArrayList list2 = new ArrayList();
        ContainerUtil.addAll(list2, iterator);
        list = list2;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.collect must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Set<T> collectSet(@NotNull Iterator<T> iterator) {
        Set set;
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.collectSet must not be null");
        }
        if (!iterator.hasNext()) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.collectSet must not return null");
            return set;
        }
        HashSet hashSet = new HashSet();
        ContainerUtil.addAll(hashSet, iterator);
        set = hashSet;
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.collectSet must not return null");
    }

    @NotNull
    public static <K, V> HashMap<K, V> assignKeys(@NotNull Iterator<V> iterator, @NotNull Convertor<V, K> keyConvertor) {
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.assignKeys must not be null");
        }
        if (keyConvertor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.assignKeys must not be null");
        }
        HashMap<K, V> hashMap = new HashMap<K, V>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            hashMap.put(keyConvertor.convert(value), value);
        }
        HashMap<K, V> hashMap2 = hashMap;
        if (hashMap2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.assignKeys must not return null");
        }
        return hashMap2;
    }

    @NotNull
    public static <K, V> Map<K, Set<V>> classify(@NotNull Iterator<V> iterator, @NotNull Convertor<V, K> keyConvertor) {
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.classify must not be null");
        }
        if (keyConvertor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.classify must not be null");
        }
        LinkedHashMap<K, LinkedHashSet<V>> hashMap = new LinkedHashMap<K, LinkedHashSet<V>>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            K key = keyConvertor.convert(value);
            LinkedHashSet<V> set = (LinkedHashSet<V>)hashMap.get(key);
            if (set == null) {
                set = new LinkedHashSet<V>();
                hashMap.put(key, set);
            }
            set.add(value);
        }
        LinkedHashMap<K, LinkedHashSet<V>> linkedHashMap = hashMap;
        if (linkedHashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.classify must not return null");
        }
        return linkedHashMap;
    }

    @NotNull
    public static <K, V> HashMap<K, V> assignValues(@NotNull Iterator<K> iterator, @NotNull Convertor<K, V> valueConvertor) {
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.assignValues must not be null");
        }
        if (valueConvertor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.assignValues must not be null");
        }
        HashMap<K, V> hashMap = new HashMap<K, V>();
        while (iterator.hasNext()) {
            K key = iterator.next();
            hashMap.put(key, valueConvertor.convert(key));
        }
        HashMap<K, V> hashMap2 = hashMap;
        if (hashMap2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.assignValues must not return null");
        }
        return hashMap2;
    }

    @NotNull
    public static <T> Iterator<T> emptyIterator() {
        EmptyIterator emptyIterator = EmptyIterator.getInstance();
        if (emptyIterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.emptyIterator must not return null");
        }
        return emptyIterator;
    }

    @NotNull
    public static <T> Iterable<T> emptyIterable() {
        EmptyIterable emptyIterable = EmptyIterable.getInstance();
        if (emptyIterable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.emptyIterable must not return null");
        }
        return emptyIterable;
    }

    @Nullable
    public static <T> T find(@NotNull T[] array, @NotNull Condition<T> condition) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<T> processor) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.process must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.process must not be null");
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list, @NotNull Processor<T> processor) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.process must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.process must not be null");
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull T[] iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.process must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.process must not be null");
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterable<V> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Nullable
    public static <T> T find(@NotNull Iterable<? extends T> iterable, final T equalTo) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        return (T)ContainerUtil.find(iterable, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return equalTo == object || equalTo.equals(object);
            }
        });
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<V> iterator, @NotNull Condition<T> condition) {
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        while (iterator.hasNext()) {
            V value = iterator.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    public static <T, V> List<V> map2List(@NotNull T[] array, @NotNull Function<T, V> mapper) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2List must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2List must not be null");
        }
        List<V> list = ContainerUtil.map2List(Arrays.asList(array), mapper);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2List must not return null");
        }
        return list;
    }

    @NotNull
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2List must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2List must not be null");
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2List must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Set must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Set must not be null");
        }
        Set<V> set = ContainerUtil.map2Set(Arrays.asList(collection), mapper);
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Set must not return null");
        }
        return set;
    }

    @NotNull
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Set must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Set must not be null");
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Set must not return null");
        }
        return hashSet;
    }

    @NotNull
    public static <T, KEY, VALUE> Map<KEY, VALUE> map2Map(@NotNull T[] collection, @NotNull Function<T, Pair<KEY, VALUE>> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Map must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Map must not be null");
        }
        Map<KEY, VALUE> map = ContainerUtil.map2Map(Arrays.asList(collection), mapper);
        if (map == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Map must not return null");
        }
        return map;
    }

    @NotNull
    public static <T, KEY, VALUE> Map<KEY, VALUE> map2Map(@NotNull Collection<? extends T> collection, @NotNull Function<T, Pair<KEY, VALUE>> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Map must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Map must not be null");
        }
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<KEY, VALUE> pair = mapper.fun(t);
            set.put(pair.first, pair.second);
        }
        THashMap tHashMap = set;
        if (tHashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Map must not return null");
        }
        return tHashMap;
    }

    @NotNull
    public static <T> Object[] map2Array(@NotNull T[] array, @NotNull Function<T, Object> mapper) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        Object[] objectArray = ContainerUtil.map2Array(array, Object.class, mapper);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Array must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static <T> Object[] map2Array(@NotNull Collection<T> array, @NotNull Function<T, Object> mapper) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        Object[] objectArray = ContainerUtil.map2Array(array, Object.class, mapper);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Array must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<? extends V> aClass, @NotNull Function<T, V> mapper) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        V[] VArray = ContainerUtil.map2Array(Arrays.asList(array), aClass, mapper);
        if (VArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Array must not return null");
        }
        return VArray;
    }

    @NotNull
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<? extends V> aClass, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        List<V> list = ContainerUtil.map2List(collection, mapper);
        Object[] objectArray = list.toArray((Object[])Array.newInstance(aClass, list.size()));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Array must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull V[] to, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        V[] VArray = ContainerUtil.map2List(collection, mapper).toArray(to);
        if (VArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Array must not return null");
        }
        return VArray;
    }

    @NotNull
    public static <T> List<T> filter(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.filter must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.filter must not be null");
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.filter must not return null");
        }
        return list;
    }

    @NotNull
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        List<? super T> list = ContainerUtil.findAll(Arrays.asList(collection), condition);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.findAll must not return null");
        }
        return list;
    }

    @NotNull
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.filter must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.filter must not be null");
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.filter must not return null");
        }
        return list;
    }

    @NotNull
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.findAll must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.skipNulls must not be null");
        }
        List<Object> list = ContainerUtil.findAll(collection, Condition.NOT_NULL);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.skipNulls must not return null");
        }
        return list;
    }

    @NotNull
    public static <T, V> List<V> findAll(@NotNull T[] collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.findAll must not return null");
        }
        return list;
    }

    @NotNull
    public static <T, V> V[] findAllAsArray(@NotNull T[] collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAllAsArray must not be null");
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAllAsArray must not be null");
        }
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        Object[] objectArray = list.toArray((Object[])Array.newInstance(instanceOf, list.size()));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.findAllAsArray must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static <T, V> V[] findAllAsArray(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAllAsArray must not be null");
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAllAsArray must not be null");
        }
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        Object[] objectArray = list.toArray((Object[])Array.newInstance(instanceOf, list.size()));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.findAllAsArray must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static <T> T[] findAllAsArray(@NotNull T[] collection, @NotNull Condition<? super T> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAllAsArray must not be null");
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAllAsArray must not be null");
        }
        List<Object> list = ContainerUtil.findAll(collection, instanceOf);
        Object[] objectArray = list.toArray((Object[])Array.newInstance(collection.getClass().getComponentType(), list.size()));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.findAllAsArray must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static <T, V> List<V> findAll(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            result.add(t);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.findAll must not return null");
        }
        return arrayList;
    }

    public static <T> void removeDuplicates(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.removeDuplicates must not be null");
        }
        HashSet<T> collected = new HashSet<T>();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!collected.contains(t)) {
                collected.add(t);
                continue;
            }
            iterator.remove();
        }
    }

    public static Map<String, String> stringMap(String ... keyValues) {
        if (keyValues == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.stringMap must not be null");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            result.put(keyValues[i], keyValues[i + 1]);
        }
        return result;
    }

    @NotNull
    public static <T> Iterator<T> iterate(@NotNull T[] arrays) {
        if (arrays == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.iterate must not be null");
        }
        Iterator<T> iterator = Arrays.asList(arrays).iterator();
        if (iterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.iterate must not return null");
        }
        return iterator;
    }

    @NotNull
    public static <T> Iterator<T> iterate(final @NotNull Enumeration<T> enumeration) {
        if (enumeration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.iterate must not be null");
        }
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.iterate must not return null");
        }
        return iterator;
    }

    @NotNull
    public static <T> Iterable<T> iterate(@NotNull T[] arrays, @NotNull Condition<? super T> condition) {
        if (arrays == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.iterate must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.iterate must not be null");
        }
        Iterable<? super T> iterable = ContainerUtil.iterate(Arrays.asList(arrays), condition);
        if (iterable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.iterate must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        Iterable iterable;
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.iterate must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.iterate must not be null");
        }
        if (collection.isEmpty()) {
            iterable = ContainerUtil.emptyIterable();
            if (iterable == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.iterate must not return null");
            return iterable;
        }
        iterable = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> impl;
                    T next;
                    {
                        this.impl = collection.iterator();
                        this.next = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result = this.next;
                        this.next = this.findNext();
                        return result;
                    }

                    private T findNext() {
                        while (this.impl.hasNext()) {
                            Object each = this.impl.next();
                            if (!condition.value(each)) continue;
                            return each;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (iterable != null) return iterable;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.iterate must not return null");
    }

    @NotNull
    public static <T> Iterable<T> iterateBackward(final @NotNull List<? extends T> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.iterateBackward must not be null");
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    ListIterator<? extends T> it;
                    {
                        this.it = list.listIterator(list.size());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return this.it.previous();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.iterateBackward must not return null");
        }
        return iterable;
    }

    public static <E> void swapElements(@NotNull List<E> list, int index1, int index2) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.swapElements must not be null");
        }
        E e1 = list.get(index1);
        E e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<?> iterator, @NotNull FilteringIterator.InstanceOf<T> instanceOf) {
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.collect must not be null");
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.collect must not be null");
        }
        List list = ContainerUtil.collect(FilteringIterator.create(iterator, instanceOf));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.collect must not return null");
        }
        return list;
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        if (enumeration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        for (A element : elements) {
            collection.add(element);
        }
        return collection;
    }

    public static <T, U extends T> U findInstance(@NotNull Iterable<T> iterable, @NotNull Class<U> aClass) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findInstance must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findInstance must not be null");
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<T> iterator, @NotNull Class<U> aClass) {
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findInstance must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findInstance must not be null");
        }
        return (U)ContainerUtil.find(iterator, new FilteringIterator.InstanceOf<U>(aClass));
    }

    @Nullable
    public static <T, U extends T> U findInstance(@NotNull T[] array, @NotNull Class<U> aClass) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findInstance must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findInstance must not be null");
        }
        return ContainerUtil.findInstance(Arrays.asList(array), aClass);
    }

    @NotNull
    public static <T, V> List<T> concat(@NotNull V[] array, @NotNull Function<V, Collection<? extends T>> fun) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        if (fun == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        List<? extends T> list = ContainerUtil.concat(Arrays.asList(array), fun);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return list;
    }

    @NotNull
    public static <T> List<T> concat(@NotNull Iterable<? extends Collection<T>> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Collection<T> ts : list) {
            result.addAll(ts);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < size1) {
                    return list1.get(index);
                }
                return list2.get(index - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return abstractList;
    }

    @NotNull
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (Iterable iterable : iterables) {
                    iterators[i] = iterable.iterator();
                }
                return new SequenceIterator(iterators);
            }
        };
        if (iterable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return iterable;
    }

    @NotNull
    public static <T> Iterable<T> concat(final T[] ... iterables) {
        if (iterables == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (Object[] iterable : iterables) {
                    iterators[i] = Arrays.asList(iterable).iterator();
                }
                return new SequenceIterator(iterators);
            }
        };
        if (iterable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return iterable;
    }

    @NotNull
    public static <T> List<T> concat(final List<? extends T> ... lists) {
        if (lists == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        final int finalSize = size;
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= 0 && index < finalSize) {
                    int from = 0;
                    for (List each : lists) {
                        if (from <= index && index < from + each.size()) {
                            return each.get(index - from);
                        }
                        from += each.size();
                    }
                }
                throw new IndexOutOfBoundsException("index: " + index + "size: " + this.size());
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return abstractList;
    }

    @NotNull
    public static <T> List<T> concat(@NotNull List<List<? extends T>> lists) {
        if (lists == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        List[] array = lists.toArray(new List[lists.size()]);
        List<T> list = ContainerUtil.concat(array);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return list;
    }

    @NotNull
    public static <T, V> List<T> concat(@NotNull Iterable<? extends V> list, @NotNull Function<V, Collection<? extends T>> fun) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        if (fun == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        ArrayList<? extends T> result = new ArrayList<T>();
        for (V v : list) {
            result.addAll(fun.fun(v));
        }
        ArrayList<? extends T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return arrayList;
    }

    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.intersects must not be null");
        }
        if (collection2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.intersects must not be null");
        }
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.intersection must not be null");
        }
        if (collection2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.intersection must not be null");
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result.add(t);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.intersection must not return null");
        }
        return arrayList;
    }

    @Nullable
    public static <T> T getFirstItem(Collection<T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    public static <T> T getFirstItem(Collection<T> items, @Nullable T def) {
        return items == null || items.isEmpty() ? def : items.iterator().next();
    }

    @Nullable
    public static <T> T iterateAndGetLastItem(@NotNull Iterable<T> items) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.iterateAndGetLastItem must not be null");
        }
        Iterator<T> itr = items.iterator();
        T res = null;
        while (itr.hasNext()) {
            res = itr.next();
        }
        return res;
    }

    @NotNull
    public static <T> Collection<T> subtract(@NotNull Collection<T> from, @NotNull Collection<T> what) {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.subtract must not be null");
        }
        if (what == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.subtract must not be null");
        }
        HashSet<T> set = new HashSet<T>(from);
        set.removeAll(what);
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.subtract must not return null");
        }
        return hashSet;
    }

    public static <T> T[] toArray(@Nullable Collection<T> c, @NotNull ArrayFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        return c != null ? c.toArray(factory.create(c.size())) : factory.create(0);
    }

    public static <T> T[] toArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (c1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        if (c2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        return ArrayUtil.mergeCollections(c1, c2, factory);
    }

    public static <T> T[] mergeCollectionsToArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (c1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mergeCollectionsToArray must not be null");
        }
        if (c2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mergeCollectionsToArray must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mergeCollectionsToArray must not be null");
        }
        return ArrayUtil.mergeCollections(c1, c2, factory);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        T[] TArray;
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        if (array == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        int length = array.length;
        if (length < 20) {
            for (int i = 0; i < collection.size(); ++i) {
                array[i] = collection.get(i);
            }
            TArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.toArray must not return null");
            return TArray;
        }
        TArray = collection.toArray(array);
        if (TArray != null) return TArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.toArray must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        T[] TArray;
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        if (sample == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        int size = c.size();
        if (size == sample.length && size < 20) {
            int i = 0;
            for (T t : c) {
                sample[i++] = t;
            }
            TArray = sample;
            if (sample == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.toArray must not return null");
            return TArray;
        }
        TArray = c.toArray(sample);
        if (TArray != null) return TArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.toArray must not return null");
    }

    public static <T extends Comparable<T>> void sort(@NotNull List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.sort must not be null");
        }
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list.get(0);
            if (t0.compareTo(t1 = (Comparable)list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    Comparable tj;
                    Comparable ti = (Comparable)list.get(i);
                    if (ti.compareTo(tj = (Comparable)list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list);
        }
    }

    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<T> comparator) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.sort must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.sort must not be null");
        }
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list.get(i);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list, comparator);
        }
    }

    public static <T extends Comparable<T>> void sort(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.sort must not be null");
        }
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (t0.compareTo(t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (ti.compareTo(tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a);
        }
    }

    public static <T> void sort(@NotNull T[] a, @NotNull Comparator<T> comparator) {
        if (a == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.sort must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.sort must not be null");
        }
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (comparator.compare(t0, t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a, comparator);
        }
    }

    @NotNull
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        ArrayList<V> result = new ArrayList<V>();
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T, V> List<V> map(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        ArrayList<V> result = new ArrayList<V>(iterable.size());
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, Function<T, V> mapping) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mapNotNull must not be null");
        }
        List<V> list = ContainerUtil.mapNotNull(Arrays.asList(array), mapping);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.mapNotNull must not return null");
        }
        return list;
    }

    public static <T, V> V[] mapNotNull(@NotNull T[] arr, @NotNull Function<T, V> mapping, @NotNull V[] emptyArray) {
        if (arr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mapNotNull must not be null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mapNotNull must not be null");
        }
        if (emptyArray == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mapNotNull must not be null");
        }
        ArrayList<V> result = new ArrayList<V>(arr.length);
        for (T t : arr) {
            V v = mapping.fun(t);
            if (v == null) continue;
            result.add(v);
        }
        return result.toArray(emptyArray);
    }

    @NotNull
    public static <T, V> List<V> mapNotNull(Iterable<? extends T> iterable, Function<T, V> mapping) {
        ArrayList<V> result = new ArrayList<V>();
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.mapNotNull must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T, V> List<V> mapNotNull(Collection<? extends T> iterable, Function<T, V> mapping) {
        ArrayList<V> result = new ArrayList<V>(iterable.size());
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.mapNotNull must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> packNullables(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.packNullables must not be null");
        }
        ArrayList list = new ArrayList();
        for (T element : elements) {
            ContainerUtil.addIfNotNull(element, list);
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.packNullables must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T, V> List<V> map(@NotNull T[] arr, @NotNull Function<T, V> mapping) {
        if (arr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        ArrayList<V> result = new ArrayList<V>(arr.length);
        for (T t : arr) {
            result.add(mapping.fun(t));
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T, V> V[] map(@NotNull T[] arr, @NotNull Function<T, V> mapping, @NotNull V[] emptyArray) {
        if (arr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        if (emptyArray == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        ArrayList<V> result = new ArrayList<V>(arr.length);
        for (T t : arr) {
            result.add(mapping.fun(t));
        }
        V[] VArray = result.toArray(emptyArray);
        if (VArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map must not return null");
        }
        return VArray;
    }

    @NotNull
    public static <T> Set<T> set(T ... items) {
        Set set = ContainerUtil.addAll(new HashSet(), items);
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.set must not return null");
        }
        return set;
    }

    public static <T> void addIfNotNull(T element, @NotNull Collection<T> result) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addIfNotNull must not be null");
        }
        if (element != null) {
            result.add(element);
        }
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result, @Nullable T element) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addIfNotNull must not be null");
        }
        if (element != null) {
            result.add(element);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull Map<K, V> result) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.putIfNotNull must not be null");
        }
        if (value != null) {
            result.put(key, value);
        }
    }

    public static <T> void add(final T element, final @NotNull Collection<T> result, @NotNull Disposable parentDisposable) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.add must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.add must not be null");
        }
        if (result.add(element)) {
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    result.remove(element);
                }
            });
        }
    }

    @NotNull
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List list = element == null ? Collections.emptyList() : Collections.singletonList(element);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.createMaybeSingletonList must not return null");
        }
        return list;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, V defaultValue) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.getOrCreate must not be null");
        }
        V value = result.get(key);
        if (value == null) {
            value = defaultValue;
            result.put(key, value);
        }
        return value;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull Factory<V> factory) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.getOrCreate must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.getOrCreate must not be null");
        }
        V value = result.get(key);
        if (value == null) {
            value = factory.create();
            result.put(key, value);
        }
        return value;
    }

    public static <T> boolean and(@NotNull T[] iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.and must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.and must not be null");
        }
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    public static <T> boolean and(@NotNull Iterable<T> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.and must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.and must not be null");
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean exists(@NotNull T[] iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.exists must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.exists must not be null");
        }
        return ContainerUtil.or(Arrays.asList(iterable), condition);
    }

    public static <T> boolean exists(@NotNull Iterable<T> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.exists must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.exists must not be null");
        }
        return ContainerUtil.or(iterable, condition);
    }

    public static <T> boolean or(@NotNull T[] iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.or must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.or must not be null");
        }
        return ContainerUtil.or(Arrays.asList(iterable), condition);
    }

    public static <T> boolean or(@NotNull Iterable<T> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.or must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.or must not be null");
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> unfold(@Nullable T t, @NotNull NullableFunction<T, T> next) {
        if (next == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.unfold must not be null");
        }
        if (t == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        while (t != null) {
            list.add(t);
            t = next.fun(t);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> dropTail(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.dropTail must not be null");
        }
        List<T> list = items.subList(0, items.size() - 1);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.dropTail must not return null");
        }
        return list;
    }

    @NotNull
    public static <T> List<T> list(T ... items) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.list must not be null");
        }
        List<T> list = Arrays.asList(items);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.list must not return null");
        }
        return list;
    }

    public static <T> void quickSort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.quickSort must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.quickSort must not be null");
        }
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(@NotNull List<T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.quickSort must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.quickSort must not be null");
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<T> x, Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.med3 must not be null");
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        CopyOnWriteArrayList<T> copyOnWriteArrayList = new CopyOnWriteArrayList<T>(ContainerUtil.<T>emptyList());
        if (copyOnWriteArrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.createEmptyCOWList must not return null");
        }
        return copyOnWriteArrayList;
    }

    @NotNull
    public static <T> List<T> emptyList() {
        EmptyList emptyList = EmptyList.INSTANCE;
        if (emptyList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.emptyList must not return null");
        }
        return emptyList;
    }

    public static void mergeSortedArrays(TIntArrayList x1, TIntArrayList y1, TIntArrayList x2, TIntArrayList y2) {
        TIntArrayList newX = new TIntArrayList();
        TIntArrayList newY = new TIntArrayList();
        int i = 0;
        int j = 0;
        while (i < x1.size() && j < x2.size()) {
            if (x1.get(i) < x2.get(j) || x1.get(i) == x2.get(j) && y1.get(i) < y2.get(j)) {
                newX.add(x1.get(i));
                newY.add(y1.get(i));
                ++i;
                continue;
            }
            if (x1.get(i) > x2.get(j) || x1.get(i) == x2.get(j) && y1.get(i) > y2.get(j)) {
                newX.add(x2.get(j));
                newY.add(y2.get(j));
                ++j;
                continue;
            }
            newX.add(x1.get(i));
            newY.add(y1.get(i));
            ++i;
            ++j;
        }
        while (i < x1.size()) {
            newX.add(x1.get(i));
            newY.add(y1.get(i));
            ++i;
        }
        while (j < x2.size()) {
            newX.add(x2.get(j));
            newY.add(y2.get(j));
            ++j;
        }
        x1.clear();
        y1.clear();
        x1.add(newX.toNativeArray());
        y1.add(newY.toNativeArray());
    }

    @NotNull
    public static <T> Set<T> singleton(final T o, final @NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.singleton must not be null");
        }
        Set set = new Set<T>(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object elem) {
                return strategy.equals(o, elem);
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    boolean atEnd;

                    @Override
                    public boolean hasNext() {
                        return !this.atEnd;
                    }

                    @Override
                    public T next() {
                        if (this.atEnd) {
                            throw new NoSuchElementException();
                        }
                        this.atEnd = true;
                        return o;
                    }

                    @Override
                    public void remove() {
                        throw new IncorrectOperationException();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return new Object[]{o};
            }

            @Override
            public <T> T[] toArray(T[] a) {
                assert (a.length == 1);
                a[0] = o;
                return a;
            }

            @Override
            public boolean add(T t) {
                throw new IncorrectOperationException();
            }

            @Override
            public boolean remove(Object o2) {
                throw new IncorrectOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return false;
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                throw new IncorrectOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new IncorrectOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new IncorrectOperationException();
            }

            @Override
            public void clear() {
                throw new IncorrectOperationException();
            }
        };
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.singleton must not return null");
        }
        return set;
    }

    @NotNull
    public static <E> List<E> flatten(@NotNull Collection<E>[] collections) {
        if (collections == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.flatten must not be null");
        }
        List<E> list = ContainerUtil.flatten(Arrays.asList(collections));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.flatten must not return null");
        }
        return list;
    }

    @NotNull
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<E>> collections) {
        if (collections == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.flatten must not be null");
        }
        ArrayList<E> result = new ArrayList<E>();
        for (Collection<E> list : collections) {
            result.addAll(list);
        }
        ArrayList<E> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.flatten must not return null");
        }
        return arrayList;
    }

    public static <K, V> V[] convert(K[] from, V[] to, Function<K, V> fun) {
        if (to.length < from.length) {
            to = (Object[])Array.newInstance(to.getClass().getComponentType(), from.length);
        }
        for (int i = 0; i < from.length; ++i) {
            to[i] = fun.fun(from[i]);
        }
        return to;
    }

    public static <T> int indexOf(List<T> list, Condition<T> condition) {
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    public static <A, B> Map<B, A> reverseMap(Map<A, B> map) {
        HashMap<B, A> result = new HashMap<B, A>();
        for (A a : map.keySet()) {
            result.put(map.get(a), a);
        }
        return result;
    }

    public static <T> boolean processRecursively(T root, PairProcessor<T, List<T>> processor) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(root);
        while (!list.isEmpty()) {
            Object o = list.removeFirst();
            if (processor.process(o, list)) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> trimToSize(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list instanceof ArrayList) {
            list = new ArrayList<T>(list);
        }
        return list;
    }

    private static class EmptyList
    extends AbstractList<Object>
    implements RandomAccess {
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        public Object[] toArray() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return a;
        }
    }
}

