/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentHashMap;
import org.jetbrains.jet.internal.gnu.trove.TObjectHashingStrategy;

public final class ConcurrentWeakHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<Key<K>, V> myMap;
    private static final Key NULL_KEY = new Key(){

        public Object get() {
            return null;
        }
    };
    private final ReferenceQueue<K> myReferenceQueue = new ReferenceQueue();
    private static final ThreadLocal<HardKey> myHardKey = new ThreadLocal<HardKey>(){

        @Override
        protected HardKey initialValue() {
            return new HardKey(null);
        }
    };
    private Set<Map.Entry<K, V>> entrySet = null;

    private void processQueue() {
        WeakKey wk;
        while ((wk = (WeakKey)this.myReferenceQueue.poll()) != null) {
            this.myMap.remove(wk);
        }
    }

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new ConcurrentHashMap<Key<K>, V>(initialCapacity, loadFactor, 4);
    }

    public ConcurrentWeakHashMap(int initialCapacity) {
        this.myMap = new ConcurrentHashMap<Key<K>, V>(initialCapacity);
    }

    public ConcurrentWeakHashMap() {
        this.myMap = new ConcurrentHashMap<Key<K>, V>();
    }

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<Key<K>> hashingStrategy) {
        this.myMap = new ConcurrentHashMap<Key<Key<K>>, V>(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    public ConcurrentWeakHashMap(Map<? extends K, ? extends V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    public ConcurrentWeakHashMap(final TObjectHashingStrategy<K> hashingStrategy) {
        this.myMap = new ConcurrentHashMap<Key<K>, V>(new TObjectHashingStrategy<Key<K>>(){

            @Override
            public int computeHashCode(Key<K> object) {
                return hashingStrategy.computeHashCode(object.get());
            }

            @Override
            public boolean equals(Key<K> o1, Key<K> o2) {
                return hashingStrategy.equals(o1.get(), o2.get());
            }
        });
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.myMap.containsKey(NULL_KEY);
        }
        HardKey hardKey = ConcurrentWeakHashMap.createHardKey(key);
        boolean result = this.myMap.containsKey(hardKey);
        ConcurrentWeakHashMap.releaseHardKey(hardKey);
        return result;
    }

    private static HardKey createHardKey(Object key) {
        HardKey hardKey = myHardKey.get();
        hardKey.setObject(key);
        return hardKey;
    }

    private static void releaseHardKey(HardKey key) {
        key.setObject(null);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.myMap.get(NULL_KEY);
        }
        HardKey hardKey = ConcurrentWeakHashMap.createHardKey(key);
        Object result = this.myMap.get(hardKey);
        ConcurrentWeakHashMap.releaseHardKey(hardKey);
        return result;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        WeakKey weakKey = WeakKey.create(key, this.myReferenceQueue);
        Key o = weakKey == null ? NULL_KEY : weakKey;
        return this.myMap.put(o, value);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        if (key == null) {
            return this.myMap.remove(NULL_KEY);
        }
        HardKey hardKey = ConcurrentWeakHashMap.createHardKey(key);
        Object result = this.myMap.remove(hardKey);
        ConcurrentWeakHashMap.releaseHardKey(hardKey);
        return result;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakHashMap.putIfAbsent must not be null");
        }
        this.processQueue();
        return this.myMap.putIfAbsent(WeakKey.create(key, this.myReferenceQueue), value);
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakHashMap.remove must not be null");
        }
        this.processQueue();
        return this.myMap.remove(WeakKey.create(key, this.myReferenceQueue), value);
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakHashMap.replace must not be null");
        }
        if (oldValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakHashMap.replace must not be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakHashMap.replace must not be null");
        }
        this.processQueue();
        return this.myMap.replace(WeakKey.create(key, this.myReferenceQueue), oldValue, newValue);
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakHashMap.replace must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakHashMap.replace must not be null");
        }
        this.processQueue();
        return this.myMap.replace(WeakKey.create(key, this.myReferenceQueue), value);
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        Set<Map.Entry<Key<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = ConcurrentWeakHashMap.this.myMap.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<Key<K>, V>> hashIterator;
                Entry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        WeakKey wk = (WeakKey)ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object t = wk.get();
                            k = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent, k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            ConcurrentWeakHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            HardKey key = ConcurrentWeakHashMap.createHardKey(o);
            Object hv = ConcurrentWeakHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && ConcurrentWeakHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                ConcurrentWeakHashMap.this.myMap.remove(key);
            }
            ConcurrentWeakHashMap.releaseHardKey(key);
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                Map.Entry ent = entry;
                WeakKey wk = (WeakKey)ent.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = ent.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;

        Entry(Map.Entry<?, V> ent, K key) {
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        private static boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Entry.valEquals(this.key, e.getKey()) && Entry.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private static class HardKey
    implements Key {
        private Object myObject;
        private int myHash;

        public HardKey(Object object) {
            this.setObject(object);
        }

        private void setObject(Object object) {
            this.myObject = object;
            this.myHash = object != null ? object.hashCode() : 0;
        }

        public Object get() {
            return this.myObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    private static class WeakKey<K>
    extends WeakReference<K>
    implements Key<K> {
        private final int myHash;

        private WeakKey(K k) {
            super(k);
            this.myHash = k.hashCode();
        }

        public static <K> WeakKey<K> create(K k) {
            return k == null ? null : new WeakKey<K>(k);
        }

        private WeakKey(K k, ReferenceQueue<K> q) {
            super(k, q);
            this.myHash = k.hashCode();
        }

        private static <K> WeakKey<K> create(K k, ReferenceQueue<K> q) {
            return k == null ? null : new WeakKey<K>(k, q);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    private static interface Key<K> {
        public K get();
    }
}

