/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.jet.internal.com.intellij.reference.SoftReference;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentHashMap;

public final class ConcurrentSoftValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, MyReference<K, V>> myMap = new ConcurrentHashMap<K, MyReference<K, V>>();
    private final ReferenceQueue<MyReference<K, V>> myQueue = new ReferenceQueue();

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            if (this.myMap.get(ref.key) != ref) continue;
            this.myMap.remove(ref.key);
        }
        return;
    }

    @Override
    public V get(Object key) {
        MyReference ref = (MyReference)this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        MyReference<K, V> oldRef = this.myMap.put(key, new MyReference<K, V>(key, value, this.myQueue));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.myMap.values();
        for (MyReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator refEntries = ConcurrentSoftValueHashMap.this.myMap.entrySet().iterator();
                return new Iterator<Map.Entry<K, V>>(){
                    Map.Entry<K, V> next;

                    @Override
                    public boolean hasNext() {
                        while (this.next == null) {
                            if (!refEntries.hasNext()) {
                                return false;
                            }
                            Map.Entry ref = (Map.Entry)refEntries.next();
                            final Object k = ref.getKey();
                            Object v = ((MyReference)ref.getValue()).get();
                            this.next = v == null ? null : new AbstractMap.SimpleEntry<K, V>(k, v){

                                @Override
                                public V setValue(V value) {
                                    Object old = super.setValue(value);
                                    ConcurrentSoftValueHashMap.this.put(k, value);
                                    return old;
                                }
                            };
                        }
                        return true;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Map.Entry r = this.next;
                        this.next = null;
                        return r;
                    }

                    @Override
                    public void remove() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        ConcurrentSoftValueHashMap.this.remove(this.next.getKey());
                    }
                };
            }

            @Override
            public int size() {
                return ConcurrentSoftValueHashMap.this.myMap.size();
            }

            @Override
            public boolean remove(Object o) {
                return ConcurrentSoftValueHashMap.this.remove(((Map.Entry)o).getKey()) != null;
            }

            @Override
            public void clear() {
                ConcurrentSoftValueHashMap.this.clear();
            }
        };
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object oldVal;
        block2: {
            MyReference<K, V> newRef;
            MyReference<K, V> oldRef;
            do {
                this.processQueue();
                newRef = new MyReference<K, V>(key, value, this.myQueue);
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block2;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return (V)oldVal;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.processQueue();
        return this.myMap.remove(key, new MyReference<Object, Object>(key, value, this.myQueue));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.processQueue();
        return this.myMap.replace(key, new MyReference<K, V>(key, oldValue, this.myQueue), new MyReference<K, V>(key, newValue, this.myQueue));
    }

    @Override
    public V replace(K key, V value) {
        this.processQueue();
        MyReference<K, V> ref = this.myMap.replace(key, new MyReference<K, V>(key, value, this.myQueue));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyReference ref = (MyReference)this.myMap.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            V v = entry.getValue();
            if (v == null) continue;
            this.put(entry.getKey(), v);
        }
    }

    private static class MyReference<K, V>
    extends SoftReference<V> {
        final K key;

        public MyReference(K key, V referent, ReferenceQueue q) {
            super(referent, q);
            this.key = key;
        }
    }
}

