/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashSet;
import org.jetbrains.jet.internal.gnu.trove.THashMap;
import org.jetbrains.jet.internal.gnu.trove.THashSet;

public class CollectionFactory {
    private CollectionFactory() {
    }

    public static <T> Set<T> newSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    public static <T> Set<T> newTroveSet(T ... elements) {
        return CollectionFactory.newTroveSet(Arrays.asList(elements));
    }

    public static <T> Set<T> newTroveSet(Collection<T> elements) {
        return new THashSet<T>(elements);
    }

    public static <T> T[] ar(T ... elements) {
        return elements;
    }

    public static <T, V> THashMap<T, V> newTroveMap() {
        return new THashMap();
    }

    public static <T> ArrayList<T> arrayList() {
        return Lists.newArrayList();
    }

    public static <T> ArrayList<T> arrayList(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }

    public static <T> List<T> arrayList(final @NotNull T[] elements, final int start, final int end) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/CollectionFactory.arrayList must not be null");
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + this.size);
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    public static <T> Stack<T> stack() {
        return new Stack();
    }

    public static <T> Set<T> hashSet() {
        return Sets.newHashSet();
    }

    public static <T, V> Map<T, V> hashMap() {
        return Maps.newHashMap();
    }

    public static <T, V> Map<T, V> hashMap(@NotNull List<T> keys, @NotNull List<V> values) {
        if (keys == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/CollectionFactory.hashMap must not be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/CollectionFactory.hashMap must not be null");
        }
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException(keys + " should have some length as " + values);
        }
        HashMap<T, V> map = Maps.newHashMap();
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    public static <T, V> LinkedHashMap<T, V> linkedMap() {
        return Maps.newLinkedHashMap();
    }

    public static <T> LinkedHashSet<T> linkedHashSet() {
        return Sets.newLinkedHashSet();
    }
}

