/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashSet;

public class BidirectionalMultiMap<K, V> {
    private final Map<K, Set<V>> myKey2Values = new HashMap<K, Set<V>>();
    private final Map<V, Set<K>> myValue2Keys = new HashMap<V, Set<K>>();

    @Nullable
    public Set<V> getValues(K key) {
        return this.myKey2Values.get(key);
    }

    @Nullable
    public Set<K> getKeys(V value) {
        return this.myValue2Keys.get(value);
    }

    public boolean containsKey(K key) {
        return this.myKey2Values.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.myValue2Keys.containsKey(value);
    }

    public boolean put(K key, V value) {
        Set<K> ks = this.myValue2Keys.get(value);
        if (ks == null) {
            ks = new HashSet<K>();
            this.myValue2Keys.put((Set<K>)value, (Set<V>)ks);
        }
        ks.add(key);
        Set<V> vs = this.myKey2Values.get(key);
        if (vs == null) {
            vs = new HashSet<V>();
            this.myKey2Values.put(key, vs);
        }
        return vs.add(value);
    }

    public boolean removeKey(K key) {
        Set<V> vs = this.myKey2Values.get(key);
        if (vs == null) {
            return false;
        }
        for (V v : vs) {
            Set<K> ks = this.myValue2Keys.get(v);
            ks.remove(key);
            if (!ks.isEmpty()) continue;
            this.myValue2Keys.remove(v);
        }
        this.myKey2Values.remove(key);
        return true;
    }

    public void remove(K key, V value) {
        Set<V> vs = this.myKey2Values.get(key);
        Set<K> ks = this.myValue2Keys.get(value);
        if (ks != null && vs != null) {
            ks.remove(key);
            vs.remove(value);
            if (ks.isEmpty()) {
                this.myValue2Keys.remove(value);
            }
            if (vs.isEmpty()) {
                this.myKey2Values.remove(key);
            }
        }
    }

    public boolean isEmpty() {
        return this.myKey2Values.isEmpty() && this.myValue2Keys.isEmpty();
    }

    public boolean removeValue(V value) {
        Set<K> ks = this.myValue2Keys.get(value);
        if (ks == null) {
            return false;
        }
        for (K k : ks) {
            Set<V> vs = this.myKey2Values.get(k);
            vs.remove(value);
            if (!vs.isEmpty()) continue;
            this.myKey2Values.remove(k);
        }
        this.myValue2Keys.remove(value);
        return true;
    }

    public void clear() {
        this.myKey2Values.clear();
        this.myValue2Keys.clear();
    }

    public Set<K> getKeys() {
        return this.myKey2Values.keySet();
    }

    public Set<V> getValues() {
        return this.myValue2Keys.keySet();
    }
}

