/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.concurrency;

import java.util.ArrayList;
import org.jetbrains.jet.internal.com.intellij.util.concurrency.WriterPreferenceReadWriteLock;
import org.jetbrains.jet.internal.gnu.trove.TIntArrayList;

public class ReentrantWriterPreferenceReadWriteLock
extends WriterPreferenceReadWriteLock {
    private long writeHolds_ = 0L;
    private final ThreadToCountMap readers_ = new ThreadToCountMap();
    private final ThreadLocal<Boolean> hasReadLock = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ThreadLocal<Boolean> hasWriteLock = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public boolean isReadLockAcquired() {
        return this.hasReadLock.get();
    }

    public boolean isWriteLockAcquired() {
        return this.hasWriteLock.get();
    }

    public synchronized boolean isReadLockAcquired(Thread thread) {
        return this.readers_.get(thread) > 0;
    }

    public synchronized boolean isWriteLockAcquired(Thread thread) {
        return this.activeWriter_ == thread;
    }

    @Override
    protected boolean allowReader() {
        return this.activeWriter_ == null && this.waitingWriters_ == 0L || this.activeWriter_ == Thread.currentThread();
    }

    @Override
    protected synchronized boolean startRead() {
        Thread t = Thread.currentThread();
        int c = this.readers_.get(t);
        if (c > 0) {
            this.readers_.put(t, c + 1);
            ++this.activeReaders_;
            return true;
        }
        if (this.allowReader()) {
            this.hasReadLock.set(true);
            this.readers_.put(t, 1);
            ++this.activeReaders_;
            return true;
        }
        return false;
    }

    @Override
    protected synchronized boolean startWrite() {
        if (this.activeWriter_ == Thread.currentThread()) {
            ++this.writeHolds_;
            return true;
        }
        if (this.writeHolds_ == 0L) {
            if (this.activeReaders_ == 0L || this.readers_.size() == 1 && this.readers_.get(Thread.currentThread()) > 0) {
                this.activeWriter_ = Thread.currentThread();
                this.hasWriteLock.set(true);
                this.writeHolds_ = 1L;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected synchronized WriterPreferenceReadWriteLock.Signaller endRead() {
        --this.activeReaders_;
        Thread t = Thread.currentThread();
        int c = this.readers_.get(t);
        if (c != 1) {
            this.readers_.put(t, c - 1);
            return null;
        }
        this.readers_.put(t, 0);
        this.hasReadLock.set(false);
        if (this.writeHolds_ > 0L) {
            return null;
        }
        if (this.activeReaders_ <= 1L && this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    @Override
    protected synchronized WriterPreferenceReadWriteLock.Signaller endWrite() {
        --this.writeHolds_;
        if (this.writeHolds_ > 0L) {
            return null;
        }
        this.activeWriter_ = null;
        this.hasWriteLock.set(false);
        if (this.waitingReaders_ > 0L && this.allowReader()) {
            return this.readerLock_;
        }
        if (this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    private static final class ThreadToCountMap {
        private final ArrayList<Thread> myThreads = new ArrayList();
        private final TIntArrayList myCounters = new TIntArrayList();
        private Thread myLastThread = null;
        private int myLastCounter;

        private ThreadToCountMap() {
        }

        public int get(Thread thread) {
            if (thread == this.myLastThread) {
                return this.myLastCounter;
            }
            int index = this.myThreads.indexOf(thread);
            int result = index >= 0 ? this.myCounters.getQuick(index) : 0;
            this.myLastThread = thread;
            this.myLastCounter = result;
            return result;
        }

        public void put(Thread thread, int count) {
            this.myLastThread = null;
            int index = this.myThreads.indexOf(thread);
            if (index >= 0) {
                if (count == 0) {
                    this.myThreads.remove(index);
                    this.myCounters.remove(index);
                } else {
                    this.myCounters.setQuick(index, count);
                }
            } else if (count != 0) {
                this.myThreads.add(thread);
                this.myCounters.add(count);
            }
        }

        public int size() {
            return this.myThreads.size();
        }
    }
}

