/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.cls;

import org.jetbrains.jet.internal.com.intellij.util.cls.BytePointer;
import org.jetbrains.jet.internal.com.intellij.util.cls.ClsFormatException;

public class ClsUtil {
    public static final int MAGIC = -889275714;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_Utf8 = 1;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_CLASS_MASK = 9753;
    public static final int ACC_FIELD_MASK = 223;
    public static final int ACC_METHOD_MASK = 1535;

    public static int readU1(BytePointer ptr) throws ClsFormatException {
        if (ptr.offset < 0 || ptr.offset >= ptr.bytes.length) {
            throw new ClsFormatException();
        }
        return ptr.bytes[ptr.offset++] & 0xFF;
    }

    public static int readU2(BytePointer ptr) throws ClsFormatException {
        int b1 = ClsUtil.readU1(ptr);
        int b2 = ClsUtil.readU1(ptr);
        return (b1 << 8) + b2;
    }

    public static int readU4(BytePointer ptr) throws ClsFormatException {
        int b1 = ClsUtil.readU1(ptr);
        int b2 = ClsUtil.readU1(ptr);
        int b3 = ClsUtil.readU1(ptr);
        int b4 = ClsUtil.readU1(ptr);
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public static long readU8(BytePointer ptr) throws ClsFormatException {
        long b1 = ClsUtil.readU1(ptr);
        long b2 = ClsUtil.readU1(ptr);
        long b3 = ClsUtil.readU1(ptr);
        long b4 = ClsUtil.readU1(ptr);
        long b5 = ClsUtil.readU1(ptr);
        long b6 = ClsUtil.readU1(ptr);
        long b7 = ClsUtil.readU1(ptr);
        long b8 = ClsUtil.readU1(ptr);
        return (b1 << 56) + (b2 << 48) + (b3 << 40) + (b4 << 32) + (b5 << 24) + (b6 << 16) + (b7 << 8) + b8;
    }

    public static String readUtf8Info(BytePointer ptr) throws ClsFormatException {
        return ClsUtil.readUtf8Info(ptr, -1, -1);
    }

    public static String readUtf8Info(BytePointer ptr, int oldChar, int newChar) throws ClsFormatException {
        int tag = ClsUtil.readU1(ptr);
        if (tag != 1) {
            throw new ClsFormatException();
        }
        int length = ClsUtil.readU2(ptr);
        return ClsUtil.readUtf8(ptr.bytes, ptr.offset, ptr.offset + length, oldChar, newChar);
    }

    public static String readUtf8Info(byte[] bytes, int startOffset) throws ClsFormatException {
        int b2;
        int b1;
        int length;
        int tag;
        int offset = startOffset;
        if (offset + 3 > bytes.length) {
            throw new ClsFormatException();
        }
        if ((tag = bytes[offset++] & 0xFF) != 1) {
            throw new ClsFormatException();
        }
        if (offset + (length = ((b1 = bytes[offset++] & 0xFF) << 8) + (b2 = bytes[offset++] & 0xFF)) > bytes.length) {
            throw new ClsFormatException();
        }
        return ClsUtil.readUtf8(bytes, offset, offset + length);
    }

    private static String readUtf8(byte[] bytes, int startOffset, int endOffset) throws ClsFormatException {
        return ClsUtil.readUtf8(bytes, startOffset, endOffset, -1, -1);
    }

    private static String readUtf8(byte[] bytes, int startOffset, int endOffset, int oldChar, int newChar) throws ClsFormatException {
        char[] buffer = new char[endOffset - startOffset];
        int bOffset = 0;
        int offset = startOffset;
        while (offset < endOffset) {
            int b;
            if ((b = bytes[offset++] & 0xFF) == 0 || b >= 240) {
                throw new ClsFormatException();
            }
            if (b < 128) {
                buffer[bOffset++] = (char)(b == oldChar ? newChar : b);
                continue;
            }
            if (offset == endOffset) {
                throw new ClsFormatException();
            }
            int b1 = bytes[offset++] & 0xFF;
            if ((b & 0x20) == 0) {
                buffer[bOffset++] = (char)(((b & 0x1F) << 6) + (b1 & 0x3F));
                continue;
            }
            if (offset == endOffset) {
                throw new ClsFormatException();
            }
            int b2 = bytes[offset++] & 0xFF;
            buffer[bOffset++] = (char)(((b & 0xF) << 12) + ((b1 & 0x3F) << 6) + (b2 & 0x3F));
        }
        return new String(buffer, 0, bOffset);
    }

    public static double readDouble(BytePointer ptr) throws ClsFormatException {
        double doubleValue;
        int low;
        int high = ClsUtil.readU4(ptr);
        long longValue = ((long)high << 32) + (long)(low = ClsUtil.readU4(ptr));
        if (longValue == 9187343239835811840L) {
            doubleValue = Double.POSITIVE_INFINITY;
        } else if (longValue == -36028797018963968L) {
            doubleValue = Double.NEGATIVE_INFINITY;
        } else if (9218868437227405313L <= longValue && longValue <= Long.MAX_VALUE) {
            doubleValue = Double.NaN;
        } else if (-4503599627370495L <= longValue && longValue <= -1L) {
            doubleValue = Double.NaN;
        } else {
            int s = longValue >> 63 == 0L ? 1 : -1;
            int e = (int)(longValue >> 52 & 0x7FFL);
            long m = e == 0 ? (longValue & 0xFFFFFFFFFFFFFL) << 1 : longValue & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            doubleValue = (double)((long)s * m) * Math.pow(2.0, e - 1075);
        }
        return doubleValue;
    }

    public static float readFloat(BytePointer ptr) throws ClsFormatException {
        float floatValue;
        int value = ClsUtil.readU4(ptr);
        if (value == 2139095040) {
            floatValue = Float.POSITIVE_INFINITY;
        } else if (value == -8388608) {
            floatValue = Float.NEGATIVE_INFINITY;
        } else if (value >= 2139095041 && value <= Integer.MAX_VALUE || value >= -8388607 && value <= -1) {
            floatValue = Float.NaN;
        } else {
            int s = value >> 31 == 0 ? 1 : -1;
            int e = value >> 23 & 0xFF;
            int m = e == 0 ? (value & 0x7FFFFF) << 1 : value & 0x7FFFFF | 0x800000;
            floatValue = (float)((double)(s * m) * Math.pow(2.0, e - 150));
        }
        return floatValue;
    }

    public static void skipAttribute(BytePointer ptr) throws ClsFormatException {
        ptr.offset += 2;
        int length = ClsUtil.readU4(ptr);
        ptr.offset += length;
    }

    public static void skipAttributes(BytePointer ptr) throws ClsFormatException {
        int count = ClsUtil.readU2(ptr);
        for (int i = 0; i < count; ++i) {
            ClsUtil.skipAttribute(ptr);
        }
    }

    public static String getTypeText(byte[] data, int offset) throws ClsFormatException {
        String text;
        int count = 0;
        while (true) {
            if (offset >= data.length) {
                throw new ClsFormatException();
            }
            if (data[offset] != 91) break;
            ++offset;
            ++count;
        }
        switch ((char)data[offset]) {
            default: {
                throw new ClsFormatException();
            }
            case 'B': {
                text = "byte";
                break;
            }
            case 'C': {
                text = "char";
                break;
            }
            case 'D': {
                text = "double";
                break;
            }
            case 'F': {
                text = "float";
                break;
            }
            case 'I': {
                text = "int";
                break;
            }
            case 'J': {
                text = "long";
                break;
            }
            case 'S': {
                text = "short";
                break;
            }
            case 'Z': {
                text = "boolean";
                break;
            }
            case 'V': {
                text = "void";
                break;
            }
            case 'L': {
                int offset1 = offset + 1;
                while (true) {
                    if (offset1 >= data.length) {
                        throw new ClsFormatException();
                    }
                    if (data[offset1] == 59) break;
                    ++offset1;
                }
                String className = ClsUtil.readUtf8(data, offset + 1, offset1, 47, 46);
                text = ClsUtil.convertClassName(className, false);
            }
        }
        for (int i = 0; i < count; ++i) {
            text = text + "[]";
        }
        return text;
    }

    public static int getTypeEndOffset(byte[] data, int startOffset) throws ClsFormatException {
        int offset;
        block3: {
            offset = startOffset;
            while (true) {
                if (offset >= data.length) {
                    throw new ClsFormatException();
                }
                if (data[offset] != 91) break;
                ++offset;
            }
            if (data[offset++] != 76) break block3;
            do {
                if (offset < data.length) continue;
                throw new ClsFormatException();
            } while (data[offset++] != 59);
        }
        return offset;
    }

    public static String convertClassName(String internalClassName, boolean convertSlashesToDots) {
        String className = convertSlashesToDots ? internalClassName.replace('/', '.') : internalClassName;
        int index = className.indexOf(36);
        if (index < 0) {
            return className;
        }
        StringBuilder buffer = new StringBuilder(className);
        while (className.length() != index + 1) {
            char c = className.charAt(index + 1);
            if (Character.isJavaIdentifierStart(c)) {
                buffer.setCharAt(index, '.');
            }
            if ((index = className.indexOf(36, index + 1)) >= 0) continue;
            break;
        }
        return buffer.toString();
    }

    public static boolean isPublic(int flags) {
        return (1 & flags) != 0;
    }

    public static boolean isProtected(int flags) {
        return (4 & flags) != 0;
    }

    public static boolean isPackageLocal(int flags) {
        return !ClsUtil.isPublic(flags) && !ClsUtil.isProtected(flags) && !ClsUtil.isPrivate(flags);
    }

    public static boolean isPrivate(int flags) {
        return (2 & flags) != 0;
    }

    public static boolean isAbstract(int flags) {
        return (0x400 & flags) != 0;
    }

    public static boolean isBridge(int flags) {
        return (0x40 & flags) != 0;
    }

    public static boolean isSynthetic(int flags) {
        return (0x1000 & flags) != 0;
    }

    public static boolean isAnnotation(int flags) {
        return (0x2000 & flags) != 0;
    }

    public static boolean isFinal(int flags) {
        return (0x10 & flags) != 0;
    }

    public static boolean isStatic(int flags) {
        return (8 & flags) != 0;
    }

    public static String literalToString(CharSequence value, char quote) {
        int length = value.length();
        StringBuilder buffer = new StringBuilder(length + 3);
        buffer.append(quote);
        block8: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                buffer.append(c);
                continue;
            }
            switch (c) {
                case '\b': {
                    buffer.append("\\b");
                    continue block8;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block8;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block8;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block8;
                }
                default: {
                    if (c == quote) {
                        buffer.append("\\").append(quote);
                        continue block8;
                    }
                    if (Character.isISOControl(c)) {
                        String hexCode = Integer.toHexString(c).toUpperCase();
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        continue block8;
                    }
                    buffer.append(c);
                }
            }
        }
        buffer.append(quote);
        return buffer.toString();
    }
}

