/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import org.jetbrains.annotations.NonNls;

public abstract class WaitFor {
    private long myWaitTime;
    private boolean myInterrupted;
    private volatile boolean myConditionRealized;
    @NonNls
    public static final String WAIT_FOR_THREAD_NAME = "WaitFor thread";

    public WaitFor() {
        this(600000);
    }

    public WaitFor(int timeoutMsecs) {
        this(timeoutMsecs, 10);
    }

    public WaitFor(int timeoutMsecs, int step) {
        long started = System.currentTimeMillis();
        long deadline = timeoutMsecs == -1 ? Long.MAX_VALUE : started + (long)timeoutMsecs;
        this.myConditionRealized = false;
        try {
            while (!(this.myConditionRealized = this.condition()) && System.currentTimeMillis() < deadline) {
                Thread.sleep(step);
            }
        }
        catch (InterruptedException e) {
            this.myInterrupted = true;
        }
        this.myWaitTime = System.currentTimeMillis() - started;
    }

    public WaitFor(final int timeoutMsecs, final Runnable toRunOnTrue) {
        new Thread(WAIT_FOR_THREAD_NAME){

            @Override
            public void run() {
                WaitFor.this.myConditionRealized = new WaitFor(timeoutMsecs){

                    @Override
                    protected boolean condition() {
                        return WaitFor.this.condition();
                    }
                }.isConditionRealized();
                if (WaitFor.this.myConditionRealized) {
                    toRunOnTrue.run();
                }
            }
        }.start();
    }

    public long getWaitedTime() {
        return this.myWaitTime;
    }

    public boolean isConditionRealized() {
        return this.myConditionRealized;
    }

    public boolean isInterrupted() {
        return this.myInterrupted;
    }

    protected abstract boolean condition();

    public void assertCompleted() {
        this.assertCompleted("");
    }

    public void assertCompleted(String message) {
        assert (this.condition()) : message;
    }
}

