/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.CommonProcessors;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.internal.com.intellij.util.Processor;
import org.jetbrains.jet.internal.com.intellij.util.Query;
import org.jetbrains.jet.internal.gnu.trove.THashSet;
import org.jetbrains.jet.internal.gnu.trove.TObjectHashingStrategy;

public class UniqueResultsQuery<T, M>
implements Query<T> {
    private final Query<T> myOriginal;
    private final TObjectHashingStrategy<M> myHashingStrategy;
    private final Function<T, M> myMapper;

    public UniqueResultsQuery(Query<T> original) {
        this(original, TObjectHashingStrategy.CANONICAL, Function.ID);
    }

    public UniqueResultsQuery(Query<T> original, TObjectHashingStrategy<M> hashingStrategy) {
        this(original, hashingStrategy, Function.ID);
    }

    public UniqueResultsQuery(Query<T> original, TObjectHashingStrategy<M> hashingStrategy, Function<T, M> mapper) {
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
        this.myMapper = mapper;
    }

    @Override
    public T findFirst() {
        return this.myOriginal.findFirst();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.forEach must not be null");
        }
        return this.process(consumer, Collections.synchronizedSet(new THashSet<M>(this.myHashingStrategy)));
    }

    private boolean process(final Processor<T> consumer, final Set<M> processedElements) {
        return this.myOriginal.forEach(new Processor<T>(){

            @Override
            public boolean process(T t) {
                return !processedElements.add(UniqueResultsQuery.this.myMapper.fun(t)) || consumer.process(t);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<T> findAll() {
        Collection<Object> collection;
        if (this.myMapper == Function.ID) {
            THashSet<M> set = new THashSet<M>(this.myHashingStrategy);
            this.process(CommonProcessors.alwaysTrue(), Collections.synchronizedSet(set));
            collection = set;
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/util/UniqueResultsQuery.findAll must not return null");
            return collection;
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(Collections.synchronizedList(new ArrayList()));
        this.forEach((Processor<T>)processor);
        collection = processor.getResults();
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/util/UniqueResultsQuery.findAll must not return null");
    }

    @Override
    public T[] toArray(T[] a) {
        return this.findAll().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }
}

