/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import org.jetbrains.jet.internal.com.intellij.util.SpinAllocator;

public class StringBuilderSpinAllocator {
    private static final SpinAllocator<StringBuilder> myAllocator = new SpinAllocator<StringBuilder>(new Creator(), new Disposer());

    private StringBuilderSpinAllocator() {
    }

    public static StringBuilder alloc() {
        return myAllocator.alloc();
    }

    public static void dispose(StringBuilder instance) {
        myAllocator.dispose(instance);
    }

    private static class Disposer
    implements SpinAllocator.IDisposer<StringBuilder> {
        private Disposer() {
        }

        @Override
        public void disposeInstance(StringBuilder instance) {
            instance.setLength(0);
            if (instance.capacity() > 1024) {
                instance.trimToSize();
            }
        }
    }

    private static class Creator
    implements SpinAllocator.ICreator<StringBuilder> {
        private Creator() {
        }

        @Override
        public StringBuilder createInstance() {
            return new StringBuilder();
        }
    }
}

