/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.io.File;
import java.io.IOException;
import org.jetbrains.jet.internal.com.intellij.openapi.application.PathManager;
import org.jetbrains.jet.internal.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.internal.com.sun.jna.Native;
import org.jetbrains.jet.internal.com.sun.jna.WString;
import org.jetbrains.jet.internal.com.sun.jna.win32.StdCallLibrary;

public class Restarter {
    private Restarter() {
    }

    public static int getRestartCode() {
        String s = System.getProperty("jb.restart.code");
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static boolean isSupported() {
        return SystemInfo.isWindows || SystemInfo.isMac;
    }

    public static boolean restart() throws CannotRestartException {
        try {
            if (SystemInfo.isWindows) {
                return Restarter.restartOnWindows();
            }
            if (SystemInfo.isMac) {
                return Restarter.restartOnMac();
            }
        }
        catch (CannotRestartException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CannotRestartException(e);
        }
        return false;
    }

    private static boolean restartOnWindows() throws CannotRestartException {
        Kernel32 kernel32 = (Kernel32)Native.loadLibrary("kernel32", Kernel32.class);
        WString cline = kernel32.GetCommandLineW();
        int pid = kernel32.GetCurrentProcessId();
        try {
            File restarterFile = new File(PathManager.getBinPath(), "restarter.exe");
            File restarterCopy = FileUtil.createTempFile("restarter", ".exe");
            FileUtil.copy(restarterFile, restarterCopy);
            String command = "\"" + restarterCopy + "\" " + Integer.toString(pid) + " " + cline;
            Runtime.getRuntime().exec(command, null, new File(PathManager.getBinPath()));
        }
        catch (IOException ex) {
            throw new CannotRestartException(ex);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private static boolean restartOnMac() throws CannotRestartException {
        String binPath = PathManager.getBinPath();
        if (!binPath.contains(".app")) {
            return false;
        }
        int appIndex = binPath.indexOf(".app");
        String appPath = binPath.substring(0, appIndex + 4);
        try {
            Runtime.getRuntime().exec(new String[]{new File(PathManager.getBinPath(), "relaunch").getPath(), appPath});
        }
        catch (IOException e) {
            throw new CannotRestartException(e);
        }
        return true;
    }

    public static class CannotRestartException
    extends Exception {
        public CannotRestartException(Throwable cause) {
            super(cause);
        }
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public WString GetCommandLineW();

        public int GetCurrentProcessId();
    }
}

