/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentFactoryMap;

public class ReflectionCache {
    private static final ConcurrentFactoryMap<Class, Class> ourSuperClasses = new ConcurrentFactoryMap<Class, Class>(){

        @Override
        protected Class create(Class key) {
            return key.getSuperclass();
        }
    };
    private static final ConcurrentFactoryMap<Class, Class[]> ourInterfaces = new ConcurrentFactoryMap<Class, Class[]>(){

        @Override
        @NotNull
        protected Class[] create(Class key) {
            Class[] classArray = key.getInterfaces();
            if (classArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$2.create must not return null");
            }
            return classArray;
        }
    };
    private static final ConcurrentFactoryMap<Class, Method[]> ourMethods = new ConcurrentFactoryMap<Class, Method[]>(){

        @Override
        @NotNull
        protected Method[] create(Class key) {
            Method[] methodArray = key.getMethods();
            if (methodArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$3.create must not return null");
            }
            return methodArray;
        }
    };
    private static final ConcurrentFactoryMap<Class, Boolean> ourIsInterfaces = new ConcurrentFactoryMap<Class, Boolean>(){

        @Override
        @NotNull
        protected Boolean create(Class key) {
            Boolean bl = key.isInterface();
            if (bl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$4.create must not return null");
            }
            return bl;
        }
    };
    private static final ConcurrentFactoryMap<Class, TypeVariable[]> ourTypeParameters = new ConcurrentFactoryMap<Class, TypeVariable[]>(){

        @Override
        @NotNull
        protected TypeVariable[] create(Class key) {
            TypeVariable[] typeVariableArray = key.getTypeParameters();
            if (typeVariableArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$5.create must not return null");
            }
            return typeVariableArray;
        }
    };
    private static final ConcurrentFactoryMap<Class, Type[]> ourGenericInterfaces = new ConcurrentFactoryMap<Class, Type[]>(){

        @Override
        @NotNull
        protected Type[] create(Class key) {
            Type[] typeArray = key.getGenericInterfaces();
            if (typeArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$6.create must not return null");
            }
            return typeArray;
        }
    };
    private static final ConcurrentFactoryMap<ParameterizedType, Type[]> ourActualTypeArguments = new ConcurrentFactoryMap<ParameterizedType, Type[]>(){

        @Override
        @NotNull
        protected Type[] create(ParameterizedType key) {
            Type[] typeArray = key.getActualTypeArguments();
            if (typeArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$7.create must not return null");
            }
            return typeArray;
        }
    };

    private ReflectionCache() {
    }

    public static Class getSuperClass(Class aClass) {
        return (Class)ourSuperClasses.get(aClass);
    }

    public static Class[] getInterfaces(Class aClass) {
        return (Class[])ourInterfaces.get(aClass);
    }

    public static Method[] getMethods(Class aClass) {
        return (Method[])ourMethods.get(aClass);
    }

    public static boolean isAssignable(@NotNull Class ancestor, Class descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ReflectionCache.isAssignable must not be null");
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    public static boolean isInstance(Object instance, Class clazz) {
        return clazz.isInstance(instance);
    }

    public static boolean isInterface(Class aClass) {
        return (Boolean)ourIsInterfaces.get(aClass);
    }

    public static <T> TypeVariable<Class<T>>[] getTypeParameters(Class<T> aClass) {
        return (TypeVariable[])ourTypeParameters.get(aClass);
    }

    public static Type[] getGenericInterfaces(Class aClass) {
        return (Type[])ourGenericInterfaces.get(aClass);
    }

    public static Type[] getActualTypeArguments(ParameterizedType type) {
        return (Type[])ourActualTypeArguments.get(type);
    }
}

