/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.ide.IconProvider;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.project.DumbService;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Iconable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;

public class PsiIconUtil {
    @Nullable
    public static Icon getProvidersIcon(PsiElement element, @Iconable.IconFlags int flags) {
        boolean dumb = DumbService.getInstance(element.getProject()).isDumb();
        for (IconProvider iconProvider : PsiIconUtil.getIconProviders()) {
            Icon icon;
            if (dumb && !DumbService.isDumbAware(iconProvider) || (icon = iconProvider.getIcon(element, flags)) == null) continue;
            return icon;
        }
        return null;
    }

    private static IconProvider[] getIconProviders() {
        return IconProviderHolder.ourIconProviders;
    }

    private static class IconProviderHolder {
        private static final IconProvider[] ourIconProviders = Extensions.getExtensions(IconProvider.EXTENSION_POINT_NAME);

        private IconProviderHolder() {
        }
    }
}

