/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectUtils {
    public static final Object NULL = new Object();

    private ObjectUtils() {
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        T t2 = ObjectUtils._assertNotNull(t);
        if (t2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ObjectUtils.assertNotNull must not return null");
        }
        return t2;
    }

    @NotNull
    private static <T> T _assertNotNull(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ObjectUtils._assertNotNull must not be null");
        }
        T t2 = t;
        if (t2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ObjectUtils._assertNotNull must not return null");
        }
        return t2;
    }

    @Nullable
    public static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ObjectUtils.notNull must not be null");
        }
        T t = value != null ? value : defaultValue;
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ObjectUtils.notNull must not return null");
        }
        return t;
    }

    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ObjectUtils.tryCast must not be null");
        }
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        return null;
    }
}

