/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.CommonProcessors;
import org.jetbrains.jet.internal.com.intellij.util.Processor;
import org.jetbrains.jet.internal.com.intellij.util.Query;

public class MergeQuery<T>
implements Query<T> {
    private final Query<? extends T> myQuery1;
    private final Query<? extends T> myQuery2;

    public MergeQuery(Query<? extends T> query1, Query<? extends T> query2) {
        this.myQuery1 = query1;
        this.myQuery2 = query2;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        ArrayList results = new ArrayList();
        this.forEach((Processor<T>)new CommonProcessors.CollectProcessor(results));
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/MergeQuery.findAll must not return null");
        }
        return arrayList;
    }

    @Override
    public T findFirst() {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<T>)processor);
        return processor.getFoundValue();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/MergeQuery.forEach must not be null");
        }
        return this.processSubQuery(consumer, this.myQuery1) && this.processSubQuery(consumer, this.myQuery2);
    }

    private <V extends T> boolean processSubQuery(final Processor<T> consumer, Query<V> query1) {
        return query1.forEach(new Processor<V>(){

            @Override
            public boolean process(V t) {
                return consumer.process(t);
            }
        });
    }

    @Override
    public T[] toArray(T[] a) {
        Collection<T> results = this.findAll();
        return results.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }
}

