/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.text.MessageFormat;
import java.util.List;
import org.jetbrains.jet.internal.org.jdom.Attribute;
import org.jetbrains.jet.internal.org.jdom.Document;
import org.jetbrains.jet.internal.org.jdom.Element;

public class JDOMCompare {
    private JDOMCompare() {
    }

    public static String diffDocuments(Document documentExpected, Document documentActual) {
        return JDOMCompare.diffElements(documentExpected.getRootElement(), documentActual.getRootElement(), "", 0);
    }

    public static String diffElements(Element elementExpected, Element elementActual, String pathPrefix, int order) {
        String result;
        String expectedTag = elementExpected.getName();
        pathPrefix = MessageFormat.format("{0}/{1}[{2}]", pathPrefix, expectedTag, order);
        String actualTag = elementActual.getName();
        if (!elementExpected.getName().equals(actualTag)) {
            return MessageFormat.format("Tag mismatch at {0}: expected={1}, actual={2}", pathPrefix, expectedTag, actualTag);
        }
        String expectedText = elementExpected.getText().trim();
        String actualText = elementActual.getText().trim();
        if (expectedText != null) {
            if (actualText == null) {
                return MessageFormat.format("Text content missing at {0}: expected={1}", pathPrefix, expectedText);
            }
            if (!expectedText.equals(actualText)) {
                return MessageFormat.format("Text content mismatch at {0}: expected={1}, actual={2}", pathPrefix, expectedText, actualText);
            }
        } else if (actualText != null) {
            return MessageFormat.format("Text content unexpected at {0}: actual={1}", pathPrefix, actualText);
        }
        if ((result = JDOMCompare.diffAttributes(elementExpected, elementActual, pathPrefix, "missing")) != null) {
            return result;
        }
        result = JDOMCompare.diffAttributes(elementActual, elementExpected, pathPrefix, "unexpected");
        if (result != null) {
            return result;
        }
        List childrenExpected = elementExpected.getChildren();
        List childrenActual = elementActual.getChildren();
        for (int i = 0; i != childrenExpected.size(); ++i) {
            Element expectedChild = (Element)childrenExpected.get(i);
            if (i >= childrenActual.size()) {
                return MessageFormat.format("Too few children at {0}, expected={1}, actual={2}, first missing tag={3}", pathPrefix, childrenExpected.size(), childrenActual.size(), expectedChild.getName());
            }
            result = JDOMCompare.diffElements(expectedChild, (Element)childrenActual.get(i), pathPrefix, i);
            if (result == null) continue;
            return result;
        }
        if (childrenExpected.size() != childrenActual.size()) {
            return MessageFormat.format("Too many children at {0}, expected={1}, actual={2}, first unexpected tag={3}", pathPrefix, childrenExpected.size(), childrenActual.size(), ((Element)childrenActual.get(childrenExpected.size())).getName());
        }
        return null;
    }

    public static String diffAttributes(Element element1, Element element2, String pathPrefix, String mode) {
        for (Object o : element1.getAttributes()) {
            Attribute attr = (Attribute)o;
            String name = attr.getName();
            String value1 = attr.getValue();
            String value2 = element2.getAttributeValue(name);
            if (value2 == null) {
                return MessageFormat.format("Attribute {2} at {0}/@{1}", pathPrefix, name, mode);
            }
            if (value1.equals(value2)) continue;
            return MessageFormat.format("Attribute value mismatch at {0}/@{1}, expected={2}, actual={3}", pathPrefix, name, value1, value2);
        }
        return null;
    }
}

