/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.ide.FileIconPatcher;
import org.jetbrains.jet.internal.com.intellij.ide.FileIconProvider;
import org.jetbrains.jet.internal.com.intellij.ide.presentation.VirtualFilePresentation;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.project.DumbService;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.IconLoader;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Iconable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.ui.IconDeferrer;
import org.jetbrains.jet.internal.com.intellij.ui.LayeredIcon;
import org.jetbrains.jet.internal.com.intellij.ui.RowIcon;
import org.jetbrains.jet.internal.com.intellij.util.FileIconKey;
import org.jetbrains.jet.internal.com.intellij.util.NullableFunction;
import org.jetbrains.jet.internal.com.intellij.util.PlatformIcons;
import org.jetbrains.jet.internal.com.intellij.util.ui.EmptyIcon;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create("iconDeferrer:projectWasEverInitialized");

    private static boolean wasEverInitialized(Project project) {
        Boolean was = project.getUserData(PROJECT_WAS_EVER_INITIALIZED);
        if (was == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, was);
            } else {
                was = false;
            }
        }
        return was;
    }

    public static Icon cropIcon(Icon icon, int maxWidth, int maxHeight) {
        if (icon.getIconHeight() <= maxHeight && icon.getIconWidth() <= maxWidth) {
            return icon;
        }
        int w = Math.min(icon.getIconWidth(), maxWidth);
        int h = Math.min(icon.getIconHeight(), maxHeight);
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(new JPanel(), g, 0, 0);
        g.dispose();
        BufferedImage img = new BufferedImage(w, h, 3);
        int offX = icon.getIconWidth() > maxWidth ? (icon.getIconWidth() - maxWidth) / 2 : 0;
        int offY = icon.getIconHeight() > maxHeight ? (icon.getIconHeight() - maxHeight) / 2 : 0;
        for (int col = 0; col < w; ++col) {
            for (int row = 0; row < h; ++row) {
                img.setRGB(col, row, image.getRGB(col + offX, row + offY));
            }
        }
        return new ImageIcon(img);
    }

    public static Icon getIcon(VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
        Icon lastIcon = Iconable.LastComputedIcon.get(file, flags);
        Icon base = lastIcon != null ? lastIcon : VirtualFilePresentation.getIcon(file);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file, project, flags), new NullableFunction<FileIconKey, Icon>(){

            @Override
            public Icon fun(FileIconKey key) {
                VirtualFile file = key.getFile();
                int flags = key.getFlags();
                Project project = key.getProject();
                if (!file.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
                    return null;
                }
                Icon providersIcon = IconUtil.getProvidersIcon(file, flags, project);
                Icon icon = providersIcon == null ? VirtualFilePresentation.getIcon(file) : providersIcon;
                boolean dumb = project != null && DumbService.getInstance(project).isDumb();
                for (FileIconPatcher patcher : IconUtil.getPatchers()) {
                    if (dumb && !DumbService.isDumbAware(patcher)) continue;
                    icon = patcher.patchIcon(icon, file, flags, project);
                }
                if ((flags & 2) != 0 && !file.isWritable()) {
                    icon = new LayeredIcon(icon, PlatformIcons.LOCKED_ICON);
                }
                if (file.isSymLink()) {
                    icon = new LayeredIcon(icon, PlatformIcons.SYMLINK_ICON);
                }
                Iconable.LastComputedIcon.put(file, icon, flags);
                return icon;
            }
        });
    }

    @Nullable
    private static Icon getProvidersIcon(VirtualFile file, @Iconable.IconFlags int flags, Project project) {
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public static Icon getEmptyIcon(boolean showVisibility) {
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/class.png"), 0);
        if (showVisibility) {
            baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/c_public.png"), 1);
        }
        return baseIcon;
    }

    @Nullable
    private static Icon createEmptyIconLike(String baseIconPath) {
        Icon baseIcon = IconLoader.findIcon(baseIconPath);
        if (baseIcon == null) {
            return EmptyIcon.ICON_16;
        }
        return new EmptyIcon(baseIcon.getIconWidth(), baseIcon.getIconHeight());
    }

    private static FileIconProvider[] getProviders() {
        return FileIconProviderHolder.myProviders;
    }

    private static FileIconPatcher[] getPatchers() {
        return FileIconPatcherHolder.ourPatchers;
    }

    public static Image toImage(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/IconUtil.toImage must not be null");
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static Icon getAddRowIcon() {
        return SystemInfo.isMac ? PlatformIcons.TABLE_ADD_ROW : PlatformIcons.ADD_ICON;
    }

    public static Icon getRemoveRowIcon() {
        return SystemInfo.isMac ? PlatformIcons.TABLE_REMOVE_ROW : PlatformIcons.DELETE_ICON;
    }

    public static Icon getMoveRowUpIcon() {
        return SystemInfo.isMac ? PlatformIcons.TABLE_MOVE_ROW_UP : PlatformIcons.MOVE_UP_ICON;
    }

    public static Icon getMoveRowDownIcon() {
        return SystemInfo.isMac ? PlatformIcons.TABLE_MOVE_ROW_DOWN : PlatformIcons.MOVE_DOWN_ICON;
    }

    public static Icon getEditIcon() {
        return SystemInfo.isMac ? PlatformIcons.TABLE_EDIT_ROW : PlatformIcons.EDIT;
    }

    private static class FileIconPatcherHolder {
        private static final FileIconPatcher[] ourPatchers = Extensions.getExtensions(FileIconPatcher.EP_NAME);

        private FileIconPatcherHolder() {
        }
    }

    private static class FileIconProviderHolder {
        private static final FileIconProvider[] myProviders = Extensions.getExtensions(FileIconProvider.EP_NAME);

        private FileIconProviderHolder() {
        }
    }
}

