/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.internal.com.intellij.util.NotNullFunction;
import org.jetbrains.jet.internal.com.intellij.util.NullableFunction;

public class FunctionUtil {
    private FunctionUtil() {
    }

    @NotNull
    public static <T> Function<T, T> id() {
        Function function = Function.ID;
        if (function == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/FunctionUtil.id must not return null");
        }
        return function;
    }

    public static <A, B> NullableFunction<A, B> nullConstant() {
        return NullableFunction.NULL;
    }

    public static <A, B> Function<A, B> constant(final B b) {
        return new Function<A, B>(){

            @Override
            public B fun(A a) {
                return b;
            }
        };
    }

    @NotNull
    public static <A, B, C> NotNullFunction<A, C> composition(final @NotNull NotNullFunction<B, C> f, final @NotNull NotNullFunction<A, B> g) {
        if (f == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/FunctionUtil.composition must not be null");
        }
        if (g == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/FunctionUtil.composition must not be null");
        }
        NotNullFunction notNullFunction = new NotNullFunction<A, C>(){

            @Override
            @NotNull
            public C fun(A a) {
                Object Result2 = f.fun(g.fun(a));
                if (Result2 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/FunctionUtil$2.fun must not return null");
                }
                return Result2;
            }
        };
        if (notNullFunction == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/FunctionUtil.composition must not return null");
        }
        return notNullFunction;
    }
}

