/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Iconable;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;

class FileIconKey {
    private final VirtualFile myFile;
    private final Project myProject;
    @Iconable.IconFlags
    private final int myFlags;

    FileIconKey(VirtualFile file, Project project, @Iconable.IconFlags int flags) {
        this.myFile = file;
        this.myProject = project;
        this.myFlags = flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileIconKey)) {
            return false;
        }
        FileIconKey that = (FileIconKey)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        if (!this.myFile.equals(that.myFile)) {
            return false;
        }
        return !(this.myProject != null ? !this.myProject.equals(that.myProject) : that.myProject != null);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + (this.myProject != null ? this.myProject.hashCode() : 0);
        result = 31 * result + this.myFlags;
        return result;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Iconable.IconFlags
    public int getFlags() {
        return this.myFlags;
    }
}

