/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EventDispatcher");
    private final T myMulticaster;
    private final List<T> myListeners;

    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/EventDispatcher.create must not be null");
        }
        return new EventDispatcher<T>(listenerClass);
    }

    private EventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/EventDispatcher.<init> must not be null");
        }
        this.myListeners = ContainerUtil.createEmptyCOWList();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            @NonNls
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                    String methodName = method.getName();
                    if (methodName.equals("toString")) {
                        return "Multicaster";
                    }
                    if (methodName.equals("hashCode")) {
                        return System.identityHashCode(proxy);
                    }
                    if (methodName.equals("equals")) {
                        return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                    }
                    LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
                    return null;
                }
                EventDispatcher.this.dispatch(method, args);
                return null;
            }
        };
        this.myMulticaster = (EventListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
    }

    @NotNull
    public T getMulticaster() {
        T t = this.myMulticaster;
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/EventDispatcher.getMulticaster must not return null");
        }
        return t;
    }

    private void dispatch(Method method, Object[] args) {
        method.setAccessible(true);
        for (EventListener listener : this.myListeners) {
            try {
                method.invoke((Object)listener, args);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                LOG.error(cause);
            }
        }
    }

    public void addListener(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/EventDispatcher.addListener must not be null");
        }
        this.myListeners.add(listener);
    }

    public void addListener(@NotNull T listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/EventDispatcher.addListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/EventDispatcher.addListener must not be null");
        }
        this.addListener(listener);
        Disposer.register(parentDisposable, new Disposable((EventListener)listener){
            final /* synthetic */ EventListener val$listener;
            {
                this.val$listener = eventListener;
            }

            @Override
            public void dispose() {
                EventDispatcher.this.removeListener(this.val$listener);
            }
        });
    }

    public void removeListener(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/EventDispatcher.removeListener must not be null");
        }
        this.myListeners.remove(listener);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    @NotNull
    public List<T> getListeners() {
        List<T> list = this.myListeners;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/EventDispatcher.getListeners must not return null");
        }
        return list;
    }
}

