/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.Processor;
import org.jetbrains.jet.internal.com.intellij.util.Query;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public class CollectionQuery<T>
implements Query<T> {
    private final Collection<T> myCollection;

    public CollectionQuery(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/CollectionQuery.<init> must not be null");
        }
        this.myCollection = collection;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        Collection<T> collection = this.myCollection;
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/CollectionQuery.findAll must not return null");
        }
        return collection;
    }

    @Override
    public T findFirst() {
        Iterator<T> i = this.iterator();
        return i.hasNext() ? (T)i.next() : null;
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/CollectionQuery.forEach must not be null");
        }
        return ContainerUtil.process(this.myCollection, consumer);
    }

    @Override
    public T[] toArray(T[] a) {
        return this.findAll().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.myCollection.iterator();
    }
}

