/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;

public class CodeWriter
extends PrintWriter {
    private final int myIndent;
    private int myIndentLevel = 0;
    private boolean myNewLineStarted = true;

    public CodeWriter(PrintWriter writer) {
        super(writer);
        this.myIndent = 2;
    }

    @Override
    public void print(@NonNls String s) {
        this.possiblyIndent(s);
        super.print(s);
        for (int i = 0; i < s.length(); ++i) {
            if (CodeWriter.isOpenBrace(s, i)) {
                ++this.myIndentLevel;
            }
            if (!CodeWriter.isCloseBrace(s, i)) continue;
            --this.myIndentLevel;
        }
    }

    private static boolean isCloseBrace(String s, int index) {
        char c = s.charAt(index);
        return c == ')' || c == ']' || c == '}';
    }

    private static boolean isOpenBrace(String s, int index) {
        char c = s.charAt(index);
        return c == '(' || c == '[' || c == '{';
    }

    @Override
    public void println() {
        ((PrintWriter)this.out).println();
        this.myNewLineStarted = true;
    }

    private void possiblyIndent(String s) {
        if (this.myNewLineStarted) {
            int firstNonBlank;
            int i;
            for (i = 0; i < s.length() && s.charAt(i) == ' '; ++i) {
            }
            int n = firstNonBlank = i < s.length() && s.charAt(i) != ' ' ? i : -1;
            if (firstNonBlank >= 0) {
                if (CodeWriter.isCloseBrace(s, firstNonBlank)) {
                    --this.myIndentLevel;
                }
                int blanksToPrint = this.myIndent * this.myIndentLevel - firstNonBlank;
                for (int j = 0; j < blanksToPrint; ++j) {
                    this.write(" ");
                }
                if (CodeWriter.isCloseBrace(s, firstNonBlank)) {
                    ++this.myIndentLevel;
                }
            }
            this.myNewLineStarted = false;
        }
    }

    @Override
    public void println(String s) {
        StringTokenizer st = new StringTokenizer(s, "\r\n", false);
        while (st.hasMoreTokens()) {
            super.println(st.nextToken());
        }
    }
}

