/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.jet.internal.com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.jet.internal.com.intellij.util.CachedValueBase;
import org.jetbrains.jet.internal.com.intellij.util.CachedValuesFactory;
import org.jetbrains.jet.internal.com.intellij.util.DefaultCachedValuesFactory;

public class CachedValuesManagerImpl
extends CachedValuesManager {
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory) {
        this.myProject = project;
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project) : factory;
    }

    @Override
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/CachedValuesManagerImpl.createCachedValue must not be null");
        }
        return this.myFactory.createCachedValue(provider, trackValue);
    }

    @Override
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/CachedValuesManagerImpl.createParameterizedCachedValue must not be null");
        }
        return this.myFactory.createParameterizedCachedValue(provider, trackValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value;
        if (dataHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/CachedValuesManagerImpl.getCachedValue must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/CachedValuesManagerImpl.getCachedValue must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/CachedValuesManagerImpl.getCachedValue must not be null");
        }
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = dh.getUserData(key);
            if (value instanceof CachedValueBase && !((CachedValueBase)((Object)value)).isFromMyProject(this.myProject)) {
                value = null;
                dataHolder.putUserData(key, null);
            }
            if (value == null) {
                value = this.createCachedValue(provider, trackValue);
                assert (((CachedValueBase)((Object)value)).isFromMyProject(this.myProject));
                value = dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = dataHolder.getUserData(key);
                if (value instanceof CachedValueBase && !((CachedValueBase)((Object)value)).isFromMyProject(this.myProject)) {
                    value = null;
                }
                if (value == null) {
                    value = this.createCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, value);
                }
            }
        }
        return value.getValue();
    }

    public Project getProject() {
        return this.myProject;
    }
}

