/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.jet.internal.com.intellij.util.Consumer;

public class BufferedListConsumer<T>
implements Consumer<List<T>> {
    private final int myInterval;
    private long myTs;
    private final int mySize;
    private final List<T> myBuffer;
    private final Consumer<List<T>> myConsumer;
    private int myCnt;
    private Runnable myFlushListener;

    public BufferedListConsumer(int size, Consumer<List<T>> consumer, int interval) {
        this.mySize = size;
        this.myBuffer = new ArrayList<T>();
        this.myConsumer = consumer;
        this.myInterval = interval;
        this.myTs = System.currentTimeMillis();
        this.myCnt = 0;
    }

    public void consumeOne(T t) {
        this.consume(Collections.singletonList(t));
    }

    @Override
    public void consume(List<T> list) {
        this.myCnt += list.size();
        this.myBuffer.addAll(list);
        long ts = System.currentTimeMillis();
        if (this.mySize <= this.myBuffer.size() || this.myInterval > 0 && ts - (long)this.myInterval > this.myTs) {
            this.myConsumer.consume(new ArrayList<T>(this.myBuffer));
            this.myBuffer.clear();
        }
        this.myTs = ts;
    }

    public void flushPart() {
        if (!this.myBuffer.isEmpty()) {
            this.myConsumer.consume(new ArrayList<T>(this.myBuffer));
            this.myBuffer.clear();
        }
    }

    public void flush() {
        this.flushPart();
        if (this.myFlushListener != null) {
            this.myFlushListener.run();
        }
    }

    public void setFlushListener(Runnable flushListener) {
        this.myFlushListener = flushListener;
    }

    public int getCnt() {
        return this.myCnt;
    }

    public Consumer<T> asConsumer() {
        return new Consumer<T>(){

            @Override
            public void consume(T t) {
                BufferedListConsumer.this.consumeOne(t);
            }
        };
    }
}

