/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.util.ArrayFactory;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.jet.internal.com.intellij.util.text.CharArrayCharSequence;
import org.jetbrains.jet.internal.gnu.trove.Equality;

public class ArrayUtil {
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Collection[] EMPTY_COLLECTION_ARRAY = new Collection[0];
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(EMPTY_CHAR_ARRAY);
    public static final File[] EMPTY_FILE_ARRAY = new File[0];
    public static final Runnable[] EMPTY_RUNNABLE_ARRAY = new Runnable[0];
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = new ArrayFactory<String>(){

        public String[] create(int count) {
            return ArrayUtil.newStringArray(count);
        }
    };
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = new ArrayFactory<Object>(){

        @Override
        public Object[] create(int count) {
            return ArrayUtil.newObjectArray(count);
        }
    };

    private ArrayUtil() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static byte[] realloc(@NotNull byte[] array, int newSize) {
        byte[] byArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.realloc must not be null");
        }
        if (newSize == 0) {
            byArray = EMPTY_BYTE_ARRAY;
            if (EMPTY_BYTE_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
            return byArray;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            byArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
            return byArray;
        }
        byte[] result = new byte[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        byArray = result;
        if (result != null) return byArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static int[] realloc(@NotNull int[] array, int newSize) {
        int[] nArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.realloc must not be null");
        }
        if (newSize == 0) {
            nArray = EMPTY_INT_ARRAY;
            if (EMPTY_INT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
            return nArray;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            nArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
            return nArray;
        }
        int[] result = new int[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        nArray = result;
        if (result != null) return nArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
    }

    @NotNull
    public static int[] append(@NotNull int[] array, int value) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.append must not return null");
        }
        return array;
    }

    @NotNull
    public static byte[] append(@NotNull byte[] array, byte value) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.append must not return null");
        }
        return array;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static char[] realloc(@NotNull char[] array, int newSize) {
        char[] cArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.realloc must not be null");
        }
        if (newSize == 0) {
            cArray = EMPTY_CHAR_ARRAY;
            if (EMPTY_CHAR_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
            return cArray;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            cArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
            return cArray;
        }
        char[] result = new char[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        cArray = result;
        if (result != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
    }

    @NotNull
    public static <T> T[] toObjectArray(@NotNull Collection<T> collection, @NotNull Class<T> aClass) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.toObjectArray must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.toObjectArray must not be null");
        }
        Object[] array = (Object[])Array.newInstance(aClass, collection.size());
        Object[] objectArray = collection.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toObjectArray must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static <T> T[] toObjectArray(@NotNull Class<T> aClass, Object ... source) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.toObjectArray must not be null");
        }
        Object[] array = (Object[])Array.newInstance(aClass, source.length);
        System.arraycopy(source, 0, array, 0, array.length);
        if (array == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toObjectArray must not return null");
        }
        return array;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Object[] toObjectArray(@NotNull Collection<?> collection) {
        Object[] objectArray;
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.toObjectArray must not be null");
        }
        if (collection.isEmpty()) {
            objectArray = EMPTY_OBJECT_ARRAY;
            if (EMPTY_OBJECT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toObjectArray must not return null");
            return objectArray;
        }
        objectArray = collection.toArray(new Object[collection.size()]);
        if (objectArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toObjectArray must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String[] toStringArray(@NotNull Collection<String> collection) {
        String[] stringArray;
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.toStringArray must not be null");
        }
        if (collection.isEmpty()) {
            stringArray = EMPTY_STRING_ARRAY;
            if (EMPTY_STRING_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toStringArray must not return null");
            return stringArray;
        }
        stringArray = ContainerUtil.toArray(collection, new String[collection.size()]);
        if (stringArray != null) return stringArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toStringArray must not return null");
    }

    @NotNull
    public static int[] toIntArray(@NotNull List<Integer> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.toIntArray must not be null");
        }
        int[] ret = new int[list.size()];
        int i = 0;
        for (Integer e : list) {
            ret[i++] = e;
        }
        if (ret == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toIntArray must not return null");
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T[] mergeArrays(@NotNull T[] a1, @NotNull T[] a2, @NotNull Class<T> aClass) {
        Object[] objectArray;
        if (a1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a1.length == 0) {
            objectArray = a2;
            if (a2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return objectArray;
        }
        if (a2.length == 0) {
            objectArray = a1;
            if (a1 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return objectArray;
        }
        Object[] result = (Object[])Array.newInstance(aClass, a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        objectArray = result;
        if (result != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T[] mergeArrays(@NotNull T[] a1, @NotNull T[] a2) {
        Class<?> class2;
        Object[] objectArray;
        if (a1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a1.length == 0) {
            objectArray = a2;
            if (a2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return objectArray;
        }
        if (a2.length == 0) {
            objectArray = a1;
            if (a1 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return objectArray;
        }
        Class<?> class1 = a1.getClass().getComponentType();
        Class<?> aClass = class1.isAssignableFrom(class2 = a2.getClass().getComponentType()) ? class1 : class2;
        Object[] result = (Object[])Array.newInstance(aClass, a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        objectArray = result;
        if (result != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
    }

    @NotNull
    public static <T> T[] mergeCollections(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (c1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeCollections must not be null");
        }
        if (c2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeCollections must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeCollections must not be null");
        }
        T[] res = factory.create(c1.size() + c2.size());
        int i = 0;
        for (T t : c1) {
            res[i++] = t;
        }
        for (T t : c2) {
            res[i++] = t;
        }
        if (res == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeCollections must not return null");
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T[] mergeArrays(@NotNull T[] a1, @NotNull T[] a2, @NotNull ArrayFactory<T> factory) {
        T[] TArray;
        if (a1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a1.length == 0) {
            TArray = a2;
            if (a2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return TArray;
        }
        if (a2.length == 0) {
            TArray = a1;
            if (a1 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return TArray;
        }
        T[] result = factory.create(a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        TArray = result;
        if (result != null) return TArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
    }

    @NotNull
    public static String[] mergeArrays(@NotNull String[] a1, String ... a2) {
        if (a1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        String[] stringArray = ArrayUtil.mergeArrays(a1, a2, STRING_ARRAY_FACTORY);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static int[] mergeArrays(@NotNull int[] a1, @NotNull int[] a2) {
        int[] nArray;
        if (a1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a1.length == 0) {
            nArray = a2;
            if (a2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return nArray;
        }
        if (a2.length == 0) {
            nArray = a1;
            if (a1 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return nArray;
        }
        int[] result = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        nArray = result;
        if (result != null) return nArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static byte[] mergeArrays(@NotNull byte[] a1, @NotNull byte[] a2) {
        byte[] byArray;
        if (a1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a1.length == 0) {
            byArray = a2;
            if (a2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return byArray;
        }
        if (a2.length == 0) {
            byArray = a1;
            if (a1 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return byArray;
        }
        byte[] result = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        byArray = result;
        if (result != null) return byArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> T[] mergeArrayAndCollection(@NotNull T[] array, @NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory) {
        T[] array2;
        T[] TArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrayAndCollection must not be null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrayAndCollection must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrayAndCollection must not be null");
        }
        if (collection.isEmpty()) {
            TArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrayAndCollection must not return null");
            return TArray;
        }
        try {
            array2 = collection.toArray(factory.create(collection.size()));
        }
        catch (ArrayStoreException e) {
            throw new RuntimeException("Bad elements in collection: " + collection, e);
        }
        if (array.length == 0) {
            TArray = array2;
            if (array2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrayAndCollection must not return null");
            return TArray;
        }
        T[] result = factory.create(array.length + collection.size());
        System.arraycopy(array, 0, result, 0, array.length);
        System.arraycopy(array2, 0, result, array.length, array2.length);
        TArray = result;
        if (result != null) return TArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrayAndCollection must not return null");
    }

    @NotNull
    public static <T> T[] append(@NotNull T[] src, T element) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        T[] TArray = ArrayUtil.append(src, element, src.getClass().getComponentType());
        if (TArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.append must not return null");
        }
        return TArray;
    }

    public static <T> T[] append(@NotNull T[] src, T element, ArrayFactory<T> factory) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        int length = src.length;
        T[] result = factory.create(length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        return result;
    }

    @NotNull
    public static <T> T[] append(@NotNull T[] src, T element, @NotNull Class<T> componentType) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        int length = src.length;
        Object[] result = (Object[])Array.newInstance(componentType, length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.append must not return null");
        }
        return result;
    }

    @NotNull
    public static <T> T[] remove(@NotNull T[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.remove must not be null");
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        Object[] result = (Object[])Array.newInstance(src.getClass().getComponentType(), length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.remove must not return null");
        }
        return result;
    }

    @NotNull
    public static <T> T[] remove(@NotNull T[] src, int idx, ArrayFactory<T> factory) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.remove must not be null");
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        T[] result = factory.create(length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.remove must not return null");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T[] remove(@NotNull T[] src, T element) {
        Object[] objectArray;
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.remove must not be null");
        }
        int idx = ArrayUtil.find(src, element);
        if (idx == -1) {
            objectArray = src;
            if (src == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.remove must not return null");
            return objectArray;
        }
        int[] nArray = ArrayUtil.remove(src, idx);
        objectArray = nArray;
        if (nArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.remove must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T[] remove(@NotNull T[] src, T element, ArrayFactory<T> factory) {
        Object[] objectArray;
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.remove must not be null");
        }
        int idx = ArrayUtil.find(src, element);
        if (idx == -1) {
            objectArray = src;
            if (src == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.remove must not return null");
            return objectArray;
        }
        int[] nArray = ArrayUtil.remove(src, idx, factory);
        objectArray = nArray;
        if (nArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.remove must not return null");
    }

    @NotNull
    public static int[] remove(@NotNull int[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.remove must not be null");
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result = new int[src.length - 1];
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.remove must not return null");
        }
        return result;
    }

    public static <T> int find(@NotNull T[] src, T obj) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.find must not be null");
        }
        for (int i = 0; i < src.length; ++i) {
            T o = src[i];
            if (!(o == null ? obj == null : o.equals(obj))) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(@NotNull T[] src, T obj) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.lastIndexOf must not be null");
        }
        for (int i = src.length - 1; i >= 0; --i) {
            T o = src[i];
            if (!(o == null ? obj == null : o.equals(obj))) continue;
            return i;
        }
        return -1;
    }

    public static int find(@NotNull int[] src, int obj) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.find must not be null");
        }
        return ArrayUtil.indexOf(src, obj);
    }

    public static boolean startsWith(byte[] array, byte[] subArray) {
        if (array == subArray) {
            return true;
        }
        if (array == null || subArray == null) {
            return false;
        }
        int length = subArray.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[i] == subArray[i]) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean startsWith(E[] array, E[] subArray) {
        if (array == subArray) {
            return true;
        }
        if (array == null || subArray == null) {
            return false;
        }
        int length = subArray.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Comparing.equal(array[i], subArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(@NotNull byte[] array, int start, @NotNull byte[] subArray) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.startsWith must not be null");
        }
        if (subArray == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.startsWith must not be null");
        }
        int length = subArray.length;
        if (array.length - start < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[start + i] == subArray[i]) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T[] a1, T[] a2, Equality<? super T> comparator) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T[] a1, T[] a2, Comparator<? super T> comparator) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.compare(a1[i], a2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static <T> T[] reverseArray(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.reverseArray must not be null");
        }
        Object[] newArray = (Object[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        if (newArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.reverseArray must not return null");
        }
        return newArray;
    }

    @NotNull
    public static int[] reverseArray(@NotNull int[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.reverseArray must not be null");
        }
        int[] newArray = (int[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        if (newArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.reverseArray must not return null");
        }
        return newArray;
    }

    public static void reverse(@NotNull char[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.reverse must not be null");
        }
        for (int i = 0; i < array.length; ++i) {
            ArrayUtil.swap(array, array.length - i - 1, i);
        }
    }

    public static int lexicographicCompare(@NotNull String[] obj1, @NotNull String[] obj2) {
        if (obj1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.lexicographicCompare must not be null");
        }
        if (obj2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.lexicographicCompare must not be null");
        }
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            String o2;
            String o1 = i < obj1.length ? obj1[i] : null;
            String string = o2 = i < obj2.length ? obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res = o1.compareToIgnoreCase(o2);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> int lexicographicCompare(@NotNull T[] obj1, @NotNull T[] obj2) {
        if (obj1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.lexicographicCompare must not be null");
        }
        if (obj2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.lexicographicCompare must not be null");
        }
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            Object o2;
            Object o1 = i < obj1.length ? obj1[i] : null;
            Object t = o2 = i < obj2.length ? (Object)obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res = ((Comparable)o1).compareTo(o2);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> void swap(@NotNull T[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.swap must not be null");
        }
        T t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(@NotNull int[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.swap must not be null");
        }
        int t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(@NotNull boolean[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.swap must not be null");
        }
        boolean t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(@NotNull char[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.swap must not be null");
        }
        char t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static <T> void rotateLeft(@NotNull T[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.rotateLeft must not be null");
        }
        T t = array[i1];
        System.arraycopy(array, i1 + 1, array, i1, i2 - i1);
        array[i2] = t;
    }

    public static <T> void rotateRight(@NotNull T[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.rotateRight must not be null");
        }
        T t = array[i2];
        System.arraycopy(array, i1, array, i1 + 1, i2 - i1);
        array[i1] = t;
    }

    public static int indexOf(@NotNull Object[] objects, Object object) {
        if (objects == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        for (int i = 0; i < objects.length; ++i) {
            if (!Comparing.equal(objects[i], object)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull Object[] objects, Object object, int start, int end) {
        if (objects == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        for (int i = start; i < end; ++i) {
            if (!Comparing.equal(objects[i], object)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(@NotNull List<T> objects, T object, @NotNull Equality<T> comparator) {
        if (objects == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (!comparator.equals(objects.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(@NotNull List<T> objects, T object, @NotNull Comparator<T> comparator) {
        if (objects == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (comparator.compare(objects.get(i), object) != 0) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(@NotNull T[] objects, T object, @NotNull Equality<T> comparator) {
        if (objects == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        for (int i = 0; i < objects.length; ++i) {
            if (!comparator.equals(objects[i], object)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull int[] ints, int value) {
        if (ints == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Object o, Object ... objects) {
        return ArrayUtil.indexOf(objects, o) >= 0;
    }

    public static int[] newIntArray(int count) {
        return count == 0 ? EMPTY_INT_ARRAY : new int[count];
    }

    public static String[] newStringArray(int count) {
        return count == 0 ? EMPTY_STRING_ARRAY : new String[count];
    }

    @NotNull
    public static Object[] newObjectArray(int count) {
        Object[] objectArray = count == 0 ? EMPTY_OBJECT_ARRAY : new Object[count];
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.newObjectArray must not return null");
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <E> E[] ensureExactSize(int count, @NotNull E[] sample) {
        Object[] objectArray;
        if (sample == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.ensureExactSize must not be null");
        }
        if (count == sample.length) {
            objectArray = sample;
            if (sample == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.ensureExactSize must not return null");
            return objectArray;
        }
        objectArray = (Object[])Array.newInstance(sample.getClass().getComponentType(), count);
        if (objectArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.ensureExactSize must not return null");
    }

    @Nullable
    public static <T> T getFirstElement(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.getFirstElement must not be null");
        }
        return array.length > 0 ? (T)array[0] : null;
    }

    @Nullable
    public static <T> T getLastElement(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.getLastElement must not be null");
        }
        return array.length > 0 ? (T)array[array.length - 1] : null;
    }

    public static <T> T[] join(T[] array1, T[] array2) {
        return ArrayUtil.mergeArrays(array1, array2);
    }
}

