/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.ui.mac.foundation;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.ui.mac.foundation.Foundation;
import org.jetbrains.jet.internal.com.intellij.ui.mac.foundation.ID;

public class MacUtil {
    public static final String MAC_NATIVE_WINDOW_SHOWING = "MAC_NATIVE_WINDOW_SHOWING";

    private MacUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ID findWindowForTitle(String title) {
        ID focusedWindow;
        block5: {
            if (title == null || title.length() == 0) {
                return null;
            }
            ID pool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
            focusedWindow = null;
            try {
                String titleString;
                ID window;
                ID windowTitle;
                ID sharedApplication = Foundation.invoke("NSApplication", "sharedApplication", new Object[0]);
                ID windows = Foundation.invoke(sharedApplication, "windows", new Object[0]);
                ID windowEnumerator = Foundation.invoke(windows, "objectEnumerator", new Object[0]);
                do {
                    if (0 != (window = Foundation.invoke(windowEnumerator, "nextObject", new Object[0])).intValue()) continue;
                    break block5;
                } while ((windowTitle = Foundation.invoke(window, "title", new Object[0])) == null || windowTitle.intValue() == 0 || !(titleString = Foundation.toStringViaUTF8(windowTitle)).equals(title) || 1 != Foundation.invoke(window, "isVisible", new Object[0]).intValue());
                focusedWindow = window;
            }
            finally {
                Foundation.invoke(pool, "release", new Object[0]);
            }
        }
        return focusedWindow;
    }

    public static synchronized void startModal(JComponent component, String key) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = component.getToolkit().getSystemEventQueue();
                while (component.getClientProperty(key) == Boolean.TRUE) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object source = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (source instanceof Component) {
                        ((Component)source).dispatchEvent(event);
                        continue;
                    }
                    if (source instanceof MenuComponent) {
                        ((MenuComponent)source).dispatchEvent(event);
                        continue;
                    }
                    System.err.println("Unable to dispatch: " + event);
                }
            } else {
                assert (false) : "Should be called from Event-Dispatch Thread only!";
                while (component.getClientProperty(key) == Boolean.TRUE) {
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static synchronized void startModal(JComponent component) {
        MacUtil.startModal(component, MAC_NATIVE_WINDOW_SHOWING);
    }
}

