/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.jet.internal.com.intellij.ui.CaptionPanel;
import org.jetbrains.jet.internal.com.intellij.ui.EngravedLabel;
import org.jetbrains.jet.internal.com.intellij.util.ui.UIUtil;

public class TitlePanel
extends CaptionPanel {
    private final JLabel myLabel;
    private final Icon myRegular;
    private final Icon myInactive;
    private boolean myHtml;

    public TitlePanel() {
        this(null, null);
    }

    public TitlePanel(Icon regular, Icon inactive) {
        this.myRegular = regular;
        this.myInactive = inactive;
        this.myLabel = new EngravedLabel();
        if (UIUtil.isUnderAquaLookAndFeel()) {
            this.myLabel.setFont(this.myLabel.getFont().deriveFont(12.0f));
        }
        this.myLabel.setForeground(Color.black);
        this.myLabel.setHorizontalAlignment(0);
        this.myLabel.setVerticalAlignment(0);
        this.myLabel.setBorder(new EmptyBorder(1, 2, 2, 2));
        this.add((Component)this.myLabel, "Center");
        this.setActive(false);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.myLabel.setIcon(active ? this.myRegular : this.myInactive);
        this.myLabel.setForeground(active ? UIUtil.getLabelForeground() : Color.gray);
    }

    public void setText(String titleText) {
        this.myHtml = titleText.indexOf(60) >= 0;
        this.myLabel.setText(titleText);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, this.getPreferredSize().height);
    }

    @Override
    public Dimension getPreferredSize() {
        String text = this.myLabel.getText();
        if (text == null || text.trim().length() == 0) {
            return new Dimension(0, 0);
        }
        Dimension preferredSize = super.getPreferredSize();
        if (!this.myHtml && preferredSize.width > 350) {
            return new Dimension(350, preferredSize.height);
        }
        return preferredSize;
    }
}

