/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;

public class RowIcon
implements Icon {
    private final Icon[] myIcons;
    private int myWidth;
    private int myHeight;

    public RowIcon(int iconCount) {
        this.myIcons = new Icon[iconCount];
    }

    public int hashCode() {
        return this.myIcons.length > 0 ? this.myIcons[0].hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof RowIcon && Arrays.equals(((RowIcon)obj).myIcons, this.myIcons);
    }

    public int getIconCount() {
        return this.myIcons.length;
    }

    public void setIcon(Icon icon, int layer) {
        this.myIcons[layer] = icon;
        this.recalculateSize();
    }

    public Icon getIcon(int index) {
        return this.myIcons[index];
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int _x = x;
        for (Icon icon : this.myIcons) {
            if (icon == null) continue;
            icon.paintIcon(c, g, _x, y);
            _x += icon.getIconWidth();
        }
    }

    @Override
    public int getIconWidth() {
        return this.myWidth;
    }

    @Override
    public int getIconHeight() {
        return this.myHeight;
    }

    private void recalculateSize() {
        int width = 0;
        int height = 0;
        for (Icon icon : this.myIcons) {
            if (icon == null) continue;
            width += icon.getIconWidth();
            height = Math.max(height, icon.getIconHeight());
        }
        this.myWidth = width;
        this.myHeight = height;
    }
}

