/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.AttributedCharacterIterator;
import org.jetbrains.jet.internal.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.jet.internal.com.intellij.ui.Graphics2DDelegate;

public class EngravedTextGraphics
extends Graphics2DDelegate {
    private static final Color SHADOW_COLOR = new Color(250, 250, 250, 140);
    private static final boolean ALLOW_ENGRAVEMENT = SystemInfo.isMac;
    private Color myShadowColor;
    private int myXOffset;
    private int myYOffset;

    public EngravedTextGraphics(Graphics2D g2d) {
        this(g2d, 0, 1, SHADOW_COLOR);
    }

    public EngravedTextGraphics(Graphics2D g2d, int xoffset, int yoffset, Color shadowColor) {
        super(g2d);
        this.myXOffset = xoffset;
        this.myYOffset = yoffset;
        this.myShadowColor = shadowColor;
    }

    @Override
    public Graphics create() {
        return new EngravedTextGraphics((Graphics2D)this.myDelegate.create(), this.myXOffset, this.myYOffset, this.myShadowColor);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        Color color;
        if (ALLOW_ENGRAVEMENT && (color = this.getColor()) != this.myShadowColor) {
            this.setColor(this.myShadowColor);
            super.drawChars(data, offset, length, x + this.myXOffset, y + this.myYOffset);
            this.setColor(color);
        }
        super.drawChars(data, offset, length, x, y);
    }

    @Override
    public void drawString(String str, int x, int y) {
        Color color;
        if (ALLOW_ENGRAVEMENT && (color = this.getColor()) != this.myShadowColor) {
            this.setColor(this.myShadowColor);
            super.drawString(str, x + this.myXOffset, y + this.myYOffset);
            this.setColor(color);
        }
        super.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        Color color;
        if (ALLOW_ENGRAVEMENT && (color = this.getColor()) != this.myShadowColor) {
            this.setColor(this.myShadowColor);
            super.drawString(iterator, x + (float)this.myXOffset, y + (float)this.myYOffset);
            this.setColor(color);
        }
        super.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        Color color;
        if (ALLOW_ENGRAVEMENT && (color = this.getColor()) != this.myShadowColor) {
            this.setColor(this.myShadowColor);
            super.drawString(iterator, x + this.myXOffset, y + this.myYOffset);
            this.setColor(color);
        }
        super.drawString(iterator, x, y);
    }

    @Override
    public void drawString(String s, float x, float y) {
        Color color;
        if (ALLOW_ENGRAVEMENT && (color = this.getColor()) != this.myShadowColor) {
            this.setColor(this.myShadowColor);
            super.drawString(s, x + (float)this.myXOffset, y + (float)this.myYOffset);
            this.setColor(color);
        }
        super.drawString(s, x, y);
    }
}

