/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.util;

import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.gnu.trove.THashMap;

public class PsiTypesUtil {
    @NonNls
    private static final Map<String, String> ourUnboxedTypes = new THashMap<String, String>();
    @NonNls
    private static final Map<String, String> ourBoxedTypes = new THashMap<String, String>();

    private PsiTypesUtil() {
    }

    public static String getDefaultValueOfType(PsiType type) {
        if (type instanceof PsiArrayType) {
            PsiClassType classType;
            int count = type.getArrayDimensions() - 1;
            PsiType componentType = type.getDeepComponentType();
            if (componentType instanceof PsiClassType && (classType = (PsiClassType)componentType).resolve() instanceof PsiTypeParameter) {
                return "null";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("new");
            buffer.append(" ");
            buffer.append(componentType.getCanonicalText());
            buffer.append("[0]");
            for (int i = 0; i < count; ++i) {
                buffer.append("[]");
            }
            return buffer.toString();
        }
        if (type instanceof PsiPrimitiveType) {
            if (PsiType.BOOLEAN.equals(type)) {
                return "false";
            }
            return "0";
        }
        return "null";
    }

    @Nullable
    public static String unboxIfPossible(String type) {
        if (type == null) {
            return null;
        }
        String s = ourUnboxedTypes.get(type);
        return s == null ? type : s;
    }

    @Nullable
    public static String boxIfPossible(String type) {
        if (type == null) {
            return null;
        }
        String s = ourBoxedTypes.get(type);
        return s == null ? type : s;
    }

    @Nullable
    public static PsiClass getPsiClass(PsiType psiType) {
        return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
    }

    public static PsiClassType getClassType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTypesUtil.getClassType must not be null");
        }
        return JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass);
    }

    @Nullable
    public static PsiClassType getLowestUpperBoundClassType(@NotNull PsiDisjunctionType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTypesUtil.getLowestUpperBoundClassType must not be null");
        }
        PsiType lub = type.getLeastUpperBound();
        if (lub instanceof PsiClassType) {
            return (PsiClassType)lub;
        }
        if (lub instanceof PsiIntersectionType) {
            for (PsiType subType : ((PsiIntersectionType)lub).getConjuncts()) {
                PsiClass aClass;
                if (!(subType instanceof PsiClassType) || (aClass = ((PsiClassType)subType).resolve()) == null || aClass.isInterface()) continue;
                return (PsiClassType)subType;
            }
        }
        return null;
    }

    static {
        ourUnboxedTypes.put("java.lang.Boolean", "boolean");
        ourUnboxedTypes.put("java.lang.Byte", "byte");
        ourUnboxedTypes.put("java.lang.Short", "short");
        ourUnboxedTypes.put("java.lang.Integer", "int");
        ourUnboxedTypes.put("java.lang.Long", "long");
        ourUnboxedTypes.put("java.lang.Float", "float");
        ourUnboxedTypes.put("java.lang.Double", "double");
        ourUnboxedTypes.put("java.lang.Character", "char");
        ourBoxedTypes.put("boolean", "java.lang.Boolean");
        ourBoxedTypes.put("byte", "java.lang.Byte");
        ourBoxedTypes.put("short", "java.lang.Short");
        ourBoxedTypes.put("int", "java.lang.Integer");
        ourBoxedTypes.put("long", "java.lang.Long");
        ourBoxedTypes.put("float", "java.lang.Float");
        ourBoxedTypes.put("double", "java.lang.Double");
        ourBoxedTypes.put("char", "java.lang.Character");
    }
}

