/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.util;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.codeInsight.runner.JavaMainMethodProvider;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Condition;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;

public class PsiMethodUtil {
    private static final JavaMainMethodProvider[] myProviders = Extensions.getExtensions(JavaMainMethodProvider.EP_NAME);
    public static final Condition<PsiClass> MAIN_CLASS = new Condition<PsiClass>(){

        @Override
        public boolean value(PsiClass psiClass) {
            if (psiClass instanceof PsiAnonymousClass) {
                return false;
            }
            if (psiClass.isInterface()) {
                return false;
            }
            return psiClass.getContainingClass() == null || psiClass.hasModifierProperty("static");
        }
    };

    private PsiMethodUtil() {
    }

    @Nullable
    public static PsiMethod findMainMethod(PsiClass aClass) {
        for (JavaMainMethodProvider provider : myProviders) {
            if (!provider.isApplicable(aClass)) continue;
            return provider.findMainInClass(aClass);
        }
        PsiMethod[] mainMethods = aClass.findMethodsByName("main", false);
        return PsiMethodUtil.findMainMethod(mainMethods);
    }

    @Nullable
    private static PsiMethod findMainMethod(PsiMethod[] mainMethods) {
        for (PsiMethod mainMethod : mainMethods) {
            if (!PsiMethodUtil.isMainMethod(mainMethod)) continue;
            return mainMethod;
        }
        return null;
    }

    public static boolean isMainMethod(PsiMethod method) {
        if (method == null || method.getContainingClass() == null) {
            return false;
        }
        if (PsiType.VOID != method.getReturnType()) {
            return false;
        }
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        PsiType type = parameters[0].getType();
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type).getComponentType();
        return componentType.equalsToText("java.lang.String");
    }

    public static boolean hasMainMethod(PsiClass psiClass) {
        for (JavaMainMethodProvider provider : myProviders) {
            if (!provider.isApplicable(psiClass)) continue;
            return provider.hasMainMethod(psiClass);
        }
        return PsiMethodUtil.findMainMethod(psiClass.findMethodsByName("main", true)) != null;
    }

    @Nullable
    public static PsiMethod findMainInClass(PsiClass aClass) {
        if (!MAIN_CLASS.value(aClass)) {
            return null;
        }
        for (JavaMainMethodProvider provider : myProviders) {
            if (!provider.isApplicable(aClass)) continue;
            return provider.findMainInClass(aClass);
        }
        return PsiMethodUtil.findMainMethod(aClass);
    }
}

