/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignatureHandMade;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.jet.internal.gnu.trove.TObjectHashingStrategy;

public class MethodSignatureUtil {
    public static final TObjectHashingStrategy<MethodSignatureBackedByPsiMethod> METHOD_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<MethodSignatureBackedByPsiMethod>(){

        @Override
        public int computeHashCode(MethodSignatureBackedByPsiMethod signature) {
            return signature.getMethod().hashCode();
        }

        @Override
        public boolean equals(MethodSignatureBackedByPsiMethod s1, MethodSignatureBackedByPsiMethod s2) {
            return s1.getMethod().equals(s2.getMethod());
        }
    };
    public static final TObjectHashingStrategy<MethodSignature> METHOD_PARAMETERS_ERASURE_EQUALITY = new TObjectHashingStrategy<MethodSignature>(){

        @Override
        public int computeHashCode(MethodSignature signature) {
            PsiType firstParamType;
            int result = signature.isConstructor() ? 0 : signature.getName().hashCode();
            PsiType[] parameterTypes = signature.getParameterTypes();
            result += 37 * parameterTypes.length;
            PsiType psiType = firstParamType = parameterTypes.length == 0 ? null : parameterTypes[0];
            if (firstParamType != null) {
                firstParamType = TypeConversionUtil.erasure(firstParamType, signature.getSubstitutor());
                result = 31 * result + firstParamType.hashCode();
            }
            return result;
        }

        @Override
        public boolean equals(MethodSignature method1, MethodSignature method2) {
            PsiType[] parameterTypes2;
            if (method1.isConstructor() != method2.isConstructor()) {
                return false;
            }
            if (!method1.isConstructor() && !method1.getName().equals(method2.getName())) {
                return false;
            }
            PsiType[] parameterTypes1 = method1.getParameterTypes();
            if (parameterTypes1.length != (parameterTypes2 = method2.getParameterTypes()).length) {
                return false;
            }
            PsiSubstitutor substitutor1 = method1.getSubstitutor();
            PsiSubstitutor substitutor2 = method2.getSubstitutor();
            for (int i = 0; i < parameterTypes1.length; ++i) {
                PsiType type2;
                PsiType type1 = TypeConversionUtil.erasure(substitutor1.substitute(parameterTypes1[i]), substitutor1);
                if (Comparing.equal(type1, type2 = TypeConversionUtil.erasure(substitutor2.substitute(parameterTypes2[i]), substitutor2))) continue;
                return false;
            }
            return true;
        }
    };

    private MethodSignatureUtil() {
    }

    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        return MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor, false);
    }

    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor, boolean isConstructor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        return new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor, isConstructor);
    }

    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameterList, @NotNull PsiSubstitutor substitutor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (typeParameterList == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        return MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor, false);
    }

    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameterList, @NotNull PsiSubstitutor substitutor, boolean isConstructor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (typeParameterList == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        return new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor, isConstructor);
    }

    public static boolean areSignaturesEqual(PsiMethod method1, PsiMethod method2) {
        return method1.getSignature(PsiSubstitutor.EMPTY).equals(method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesEqual(MethodSignature method1, MethodSignature method2) {
        if (method2 == method1) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2)) {
            return false;
        }
        PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method1, method2);
        return MethodSignatureUtil.checkSignaturesEqualInner(method1, method2, unifyingSubstitutor);
    }

    private static boolean checkSignaturesEqualInner(MethodSignature subSignature, MethodSignature superSignature, PsiSubstitutor unifyingSubstitutor) {
        if (unifyingSubstitutor == null) {
            return false;
        }
        if (!METHOD_PARAMETERS_ERASURE_EQUALITY.equals(subSignature, superSignature)) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type2;
            PsiType type1 = unifyingSubstitutor.substitute(subParameterTypes[i]);
            if (Comparing.equal(type1, type2 = unifyingSubstitutor.substitute(superParameterTypes[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean areSignaturesEqualLightweight(MethodSignature sig1, MethodSignature sig2) {
        PsiType[] parameterTypes2;
        String name2;
        String name1;
        boolean isConstructor2;
        boolean isConstructor1 = sig1.isConstructor();
        if (isConstructor1 != (isConstructor2 = sig2.isConstructor())) {
            return false;
        }
        if (!((isConstructor1 || isConstructor2) && (sig1 instanceof HierarchicalMethodSignature || sig2 instanceof HierarchicalMethodSignature) || (name1 = sig1.getName()).equals(name2 = sig2.getName()))) {
            return false;
        }
        PsiType[] parameterTypes1 = sig1.getParameterTypes();
        if (parameterTypes1.length != (parameterTypes2 = sig2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < parameterTypes1.length; ++i) {
            PsiType type1 = parameterTypes1[i];
            PsiType type2 = parameterTypes2[i];
            if (type1 instanceof PsiPrimitiveType != type2 instanceof PsiPrimitiveType) {
                return false;
            }
            if (!(type1 instanceof PsiPrimitiveType) || type1.equals(type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuperMethod(PsiMethod superMethodCandidate, PsiMethod derivedMethod) {
        PsiClass superClassCandidate = superMethodCandidate.getContainingClass();
        PsiClass derivedClass = derivedMethod.getContainingClass();
        if (derivedClass == null || superClassCandidate == null) {
            return false;
        }
        if (!derivedClass.isInheritor(superClassCandidate, true)) {
            return false;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClassCandidate, derivedClass, PsiSubstitutor.EMPTY);
        MethodSignature superSignature = superMethodCandidate.getSignature(superSubstitutor);
        MethodSignature derivedSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.isSubsignature(superSignature, derivedSignature);
    }

    @Nullable
    public static PsiMethod findMethodInSuperClassBySignatureInDerived(@NotNull PsiClass aClass, @NotNull PsiClass superClass, MethodSignature signature, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived must not be null");
        }
        if (superClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived must not be null");
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(superClass, superSubstitutor, signature, checkDeep);
    }

    @Nullable
    private static PsiMethod doFindMethodInSuperClassBySignatureInDerived(PsiClass superClass, PsiSubstitutor superSubstitutor, MethodSignature signature, boolean checkDeep) {
        PsiClass clazz;
        PsiMethod[] methods;
        String name = signature.getName();
        for (PsiMethod method : methods = superClass.findMethodsByName(name, false)) {
            if (!MethodSignatureUtil.isSubsignature(method.getSignature(superSubstitutor), signature)) continue;
            return method;
        }
        if (checkDeep && (clazz = superClass.getSuperClass()) != null) {
            PsiSubstitutor substitutor1 = TypeConversionUtil.getSuperClassSubstitutor(clazz, superClass, superSubstitutor);
            return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(clazz, substitutor1, signature, true);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(PsiClass aClass, PsiMethod pattenMethod, boolean checkBases) {
        return MethodSignatureUtil.findMethodBySignature(aClass, pattenMethod.getSignature(PsiSubstitutor.EMPTY), checkBases);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(PsiClass aClass, MethodSignature methodSignature, boolean checkBases) {
        String name = methodSignature.isConstructor() ? aClass.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor);
            if (!methodSignature.equals(foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperSignature(PsiClass aClass, MethodSignature methodSignature, boolean checkBases) {
        String name = methodSignature.isConstructor() ? aClass.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor);
            if (!MethodSignatureUtil.isSubsignature(methodSignature, foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperMethod(PsiClass aClass, PsiMethod method, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(method.getName(), checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            MethodSignature superSignature;
            PsiSubstitutor superSubstitutor;
            PsiMethod candidate = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature candidateSignature = candidate.getSignature(substitutor);
            PsiClass methodClass = method.getContainingClass();
            PsiClass candidateClass = candidate.getContainingClass();
            if (methodClass == null || candidateClass == null || (superSubstitutor = TypeConversionUtil.getClassSubstitutor(methodClass, candidateClass, substitutor)) == null || !MethodSignatureUtil.isSubsignature(superSignature = method.getSignature(superSubstitutor), candidateSignature)) continue;
            return candidate;
        }
        return null;
    }

    public static boolean hasOverloads(PsiMethod method) {
        return MethodSignatureUtil.getOverloads(method).length > 1;
    }

    public static PsiMethod[] getOverloads(PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return new PsiMethod[]{method};
        }
        return aClass.findMethodsByName(method.getName(), false);
    }

    public static boolean areParametersErasureEqual(PsiMethod method1, PsiMethod method2) {
        return MethodSignatureUtil.areSignaturesErasureEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesErasureEqual(MethodSignature signature1, MethodSignature signature2) {
        return METHOD_PARAMETERS_ERASURE_EQUALITY.equals(signature1, signature2);
    }

    @Nullable
    public static PsiSubstitutor getSuperMethodSignatureSubstitutor(MethodSignature methodSignature, MethodSignature superMethodSignature) {
        PsiSubstitutor result = MethodSignatureUtil.getSuperMethodSignatureSubstitutorImpl(methodSignature, superMethodSignature);
        if (result == null) {
            return null;
        }
        PsiTypeParameter[] methodTypeParameters = methodSignature.getTypeParameters();
        PsiTypeParameter[] superTypeParameters = superMethodSignature.getTypeParameters();
        PsiSubstitutor methodSubstitutor = methodSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiTypeParameter superTypeParameter = superTypeParameters[i];
            HashSet<PsiType> methodSupers = new HashSet<PsiType>();
            for (PsiClassType methodSuper : methodTypeParameter.getSuperTypes()) {
                methodSupers.add(methodSubstitutor.substitute(methodSuper));
            }
            HashSet<PsiType> superSupers = new HashSet<PsiType>();
            for (PsiClassType superSuper : superTypeParameter.getSuperTypes()) {
                superSupers.add(methodSubstitutor.substitute(PsiUtil.captureToplevelWildcards(result.substitute(superSuper), methodTypeParameter)));
            }
            if (((Object)methodSupers).equals(superSupers)) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private static PsiSubstitutor getSuperMethodSignatureSubstitutorImpl(MethodSignature methodSignature, MethodSignature superSignature) {
        PsiTypeParameter[] superTypeParameters;
        PsiTypeParameter[] methodTypeParameters = methodSignature.getTypeParameters();
        if (methodTypeParameters.length != (superTypeParameters = superSignature.getTypeParameters()).length) {
            return null;
        }
        PsiSubstitutor result = superSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiElementFactory factory = JavaPsiFacade.getInstance(methodTypeParameter.getProject()).getElementFactory();
            result = result.put(superTypeParameters[i], factory.createType(methodTypeParameter));
        }
        return result;
    }

    public static PsiSubstitutor combineSubstitutors(PsiSubstitutor substitutor1, PsiSubstitutor substitutor2) {
        PsiTypeParameter[] typeParameters;
        if (substitutor1 == PsiSubstitutor.EMPTY) {
            return substitutor2;
        }
        Set<PsiTypeParameter> parameters1 = substitutor1.getSubstitutionMap().keySet();
        for (PsiTypeParameter typeParameter : typeParameters = parameters1.toArray(new PsiTypeParameter[parameters1.size()])) {
            PsiClass resolved;
            PsiType type = substitutor1.substitute(typeParameter);
            PsiType otherSubstituted = type instanceof PsiClassType ? ((resolved = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter ? substitutor2.substitute((PsiTypeParameter)resolved) : substitutor2.substitute(type)) : substitutor2.substitute(type);
            substitutor1 = substitutor1.put(typeParameter, otherSubstituted);
        }
        return substitutor1;
    }

    @NotNull
    public static PsiMethod[] convertMethodSignaturesToMethods(List<? extends MethodSignatureBackedByPsiMethod> sameNameMethodList) {
        PsiMethod[] methods = new PsiMethod[sameNameMethodList.size()];
        for (int i = 0; i < sameNameMethodList.size(); ++i) {
            methods[i] = sameNameMethodList.get(i).getMethod();
        }
        if (methods == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.convertMethodSignaturesToMethods must not return null");
        }
        return methods;
    }

    public static boolean isSubsignature(MethodSignature superSignature, MethodSignature subSignature) {
        if (subSignature == superSignature) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(superSignature, subSignature)) {
            return false;
        }
        PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(subSignature, superSignature);
        if (MethodSignatureUtil.checkSignaturesEqualInner(superSignature, subSignature, unifyingSubstitutor)) {
            return true;
        }
        if (subSignature.getTypeParameters().length > 0) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type1 = subParameterTypes[i];
            PsiType type2 = TypeConversionUtil.erasure(superParameterTypes[i]);
            if (Comparing.equal(type1, type2)) continue;
            return false;
        }
        return true;
    }
}

