/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.util;

import java.util.Map;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassObjectAccessExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiVariable;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.gnu.trove.THashMap;

public class IsConstantExpressionVisitor
extends JavaElementVisitor {
    protected boolean myIsConstant;
    private final Map<PsiVariable, Boolean> varIsConst = new THashMap<PsiVariable, Boolean>();

    public boolean isConstant() {
        return this.myIsConstant;
    }

    @Override
    public void visitExpression(PsiExpression expression) {
        this.myIsConstant = false;
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression) {
        this.myIsConstant = !"null".equals(expression.getText());
    }

    @Override
    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        this.myIsConstant = true;
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        PsiExpression expr = expression.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        PsiExpression operand = expression.getOperand();
        if (operand == null) {
            this.myIsConstant = false;
            return;
        }
        operand.accept(this);
        if (!this.myIsConstant) {
            return;
        }
        PsiTypeElement element = expression.getCastType();
        if (element == null) {
            this.myIsConstant = false;
            return;
        }
        PsiType type = element.getType();
        if (type instanceof PsiPrimitiveType) {
            return;
        }
        if (type.equalsToText("java.lang.String")) {
            return;
        }
        this.myIsConstant = false;
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression) {
        PsiExpression operand = expression.getOperand();
        if (operand == null) {
            this.myIsConstant = false;
            return;
        }
        operand.accept(this);
        if (!this.myIsConstant) {
            return;
        }
        IElementType opType = expression.getOperationTokenType();
        if (opType == JavaTokenType.PLUS || opType == JavaTokenType.MINUS || opType == JavaTokenType.TILDE || opType == JavaTokenType.EXCL) {
            return;
        }
        this.myIsConstant = false;
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        for (PsiExpression operand : expression.getOperands()) {
            operand.accept(this);
            if (this.myIsConstant) continue;
            return;
        }
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression) {
        PsiExpression thenExpr = expression.getThenExpression();
        PsiExpression elseExpr = expression.getElseExpression();
        if (thenExpr == null || elseExpr == null) {
            this.myIsConstant = false;
            return;
        }
        expression.getCondition().accept(this);
        if (!this.myIsConstant) {
            return;
        }
        thenExpr.accept(this);
        if (!this.myIsConstant) {
            return;
        }
        elseExpr.accept(this);
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        PsiElement refElement = expression.resolve();
        if (!(refElement instanceof PsiVariable)) {
            this.myIsConstant = false;
            return;
        }
        PsiVariable variable = (PsiVariable)refElement;
        Boolean isConst = this.varIsConst.get(variable);
        if (isConst != null) {
            this.myIsConstant &= isConst.booleanValue();
            return;
        }
        if (variable instanceof PsiEnumConstant) {
            this.myIsConstant = true;
            this.varIsConst.put(variable, Boolean.TRUE);
            return;
        }
        this.varIsConst.put(variable, Boolean.FALSE);
        if (!variable.hasModifierProperty("final")) {
            this.myIsConstant = false;
            return;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            this.myIsConstant = false;
            return;
        }
        initializer.accept(this);
        this.varIsConst.put(variable, this.myIsConstant);
    }
}

