/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.util;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.jet.internal.com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.ParameterizedCachedValueProvider;

public abstract class CachedValuesManager {
    private static final NotNullLazyKey<CachedValuesManager, Project> INSTANCE_KEY = ServiceManager.createLazyKey(CachedValuesManager.class);

    public static CachedValuesManager getManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.getManager must not be null");
        }
        return INSTANCE_KEY.getValue(project);
    }

    public abstract <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> var1, boolean var2);

    public abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> var1, boolean var2);

    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.createCachedValue must not be null");
        }
        return this.createCachedValue(provider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, D extends UserDataHolder, P> T getParameterizedCachedValue(@NotNull D dataHolder, @NotNull Key<ParameterizedCachedValue<T, P>> key, @NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue, P parameter) {
        ParameterizedCachedValue<T, P> value;
        if (dataHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.getParameterizedCachedValue must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.getParameterizedCachedValue must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.getParameterizedCachedValue must not be null");
        }
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = dh.getUserData(key);
            if (value == null) {
                value = this.createParameterizedCachedValue(provider, trackValue);
                value = dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = dataHolder.getUserData(key);
                if (value == null) {
                    value = this.createParameterizedCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, value);
                }
            }
        }
        return value.getValue(parameter);
    }

    public abstract <T, D extends UserDataHolder> T getCachedValue(@NotNull D var1, @NotNull Key<CachedValue<T>> var2, @NotNull CachedValueProvider<T> var3, boolean var4);

    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull CachedValueProvider<T> provider) {
        if (dataHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.getCachedValue must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.getCachedValue must not be null");
        }
        return this.getCachedValue(dataHolder, new MemoizationKey<CachedValue<T>>(provider.getClass().getName()), provider, false);
    }

    public static class MemoizationKey<T>
    extends Key<T> {
        private final String myName;

        public MemoizationKey(@NotNull @NonNls String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager$MemoizationKey.<init> must not be null");
            }
            super(name);
            this.myName = name;
        }

        @Override
        public int hashCode() {
            return this.myName.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof MemoizationKey && this.myName.equals(((MemoizationKey)obj).myName);
        }
    }
}

