/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.tree;

import java.util.Arrays;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.LogUtil;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class TokenSet {
    public static final TokenSet EMPTY = new TokenSet();
    private final boolean[] mySet = new boolean[IElementType.getAllocatedTypesCount()];
    private volatile IElementType[] myTypes;

    public IElementType[] getTypes() {
        IElementType[] types = this.myTypes;
        if (types == null) {
            int elementCount = 0;
            for (boolean bit : this.mySet) {
                if (!bit) continue;
                ++elementCount;
            }
            types = new IElementType[elementCount];
            int count = 0;
            for (short i = 1; i < this.mySet.length; i = (short)(i + 1)) {
                if (!this.mySet[i]) continue;
                types[count++] = IElementType.find(i);
            }
            this.myTypes = types;
        }
        return types;
    }

    public static TokenSet create(IElementType ... types) {
        TokenSet set = new TokenSet();
        for (IElementType type : types) {
            if (type == null) continue;
            short index = type.getIndex();
            assert (index >= 0) : "Unregistered elements are not allowed here: " + LogUtil.objectAndClass(type);
            set.mySet[index] = true;
        }
        return set;
    }

    public static TokenSet orSet(TokenSet ... sets) {
        TokenSet newSet = new TokenSet();
        for (TokenSet set : sets) {
            for (int i = 0; i < newSet.mySet.length && i < set.mySet.length; ++i) {
                int n = i;
                newSet.mySet[n] = newSet.mySet[n] | set.mySet[i];
            }
        }
        return newSet;
    }

    public static TokenSet andSet(TokenSet a, TokenSet b) {
        TokenSet set = new TokenSet();
        boolean[] aset = a.mySet;
        boolean[] bset = b.mySet;
        boolean[] newset = set.mySet;
        int alen = aset.length;
        int blen = bset.length;
        int andSize = Math.max(newset.length, Math.max(alen, blen));
        for (int i = 0; i < andSize; ++i) {
            newset[i] = i < alen && aset[i] && i < blen && bset[i];
        }
        return set;
    }

    public boolean isInSet(IElementType t) {
        return this.contains(t);
    }

    public boolean contains(IElementType t) {
        if (t == null) {
            return false;
        }
        short i = t.getIndex();
        return 0 <= i && i < this.mySet.length && this.mySet[i];
    }

    public TokenSet minus(TokenSet t) {
        TokenSet set = new TokenSet();
        for (int i = 0; i < this.mySet.length; ++i) {
            set.mySet[i] = this.mySet[i] && (i >= t.mySet.length || !t.mySet[i]);
        }
        return set;
    }

    public static TokenSet not(TokenSet t) {
        TokenSet set = new TokenSet();
        for (int i = 0; i < t.mySet.length; ++i) {
            set.mySet[i] = i >= t.mySet.length || !t.mySet[i];
        }
        return set;
    }

    public String toString() {
        return Arrays.asList(this.getTypes()).toString();
    }
}

