/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.stubs;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.BinaryFileStubBuilders;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.jet.internal.com.intellij.util.indexing.FileContent;
import org.jetbrains.jet.internal.com.intellij.util.indexing.IndexingDataKeys;
import org.jetbrains.jet.internal.com.intellij.util.indexing.SubstitutedFileType;

public class StubTreeBuilder {
    private static final Key<StubElement> stubElementKey = Key.create("stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static StubElement buildStubTree(FileContent inputData) {
        StubElement data = inputData.getUserData(stubElementKey);
        if (data != null) {
            return data;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data = inputData.getUserData(stubElementKey);
            if (data != null) {
                return data;
            }
            FileType fileType = inputData.getFileType();
            if (fileType.isBinary()) {
                BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
                assert (builder != null);
                data = builder.buildStubTree(inputData.getFile(), inputData.getContent(), inputData.getProject());
            } else {
                LanguageFileType filetype = (LanguageFileType)fileType;
                Language l = filetype.getLanguage();
                IFileElementType type = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l)).getFileNodeType();
                PsiFile psi = inputData.getPsiFile();
                CharSequence contentAsText = inputData.getContentAsText();
                psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, contentAsText);
                try {
                    if (type instanceof IStubFileElementType) {
                        data = ((IStubFileElementType)type).getBuilder().buildStubTree(psi);
                    } else if (filetype instanceof SubstitutedFileType) {
                        SubstitutedFileType substituted = (SubstitutedFileType)filetype;
                        LanguageFileType original = (LanguageFileType)substituted.getOriginalFileType();
                        IFileElementType originalType = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(original.getLanguage())).getFileNodeType();
                        data = ((IStubFileElementType)originalType).getBuilder().buildStubTree(psi);
                    }
                }
                finally {
                    psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, null);
                }
            }
            inputData.putUserData(stubElementKey, data);
            return data;
        }
    }
}

