/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.SerializationManager;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubBase;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubIndexKey;
import org.jetbrains.jet.internal.gnu.trove.THashMap;
import org.jetbrains.jet.internal.gnu.trove.TIntArrayList;

public class StubTree {
    private final PsiFileStub myRoot;
    private final List<StubElement<?>> myPlainList;

    public StubTree(@NotNull PsiFileStub root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/StubTree.<init> must not be null");
        }
        this.myPlainList = new ArrayList();
        this.myRoot = root;
        StubTree.enumerateStubs(root, this.myPlainList);
    }

    private static void enumerateStubs(StubElement<?> root, List<StubElement<?>> result) {
        ((StubBase)root).id = result.size();
        result.add(root);
        for (StubElement child : root.getChildrenStubs()) {
            StubTree.enumerateStubs(child, result);
        }
    }

    @NotNull
    public PsiFileStub getRoot() {
        PsiFileStub psiFileStub = this.myRoot;
        if (psiFileStub == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/StubTree.getRoot must not return null");
        }
        return psiFileStub;
    }

    public List<StubElement<?>> getPlainList() {
        return this.myPlainList;
    }

    @NotNull
    public Map<StubIndexKey, Map<Object, TIntArrayList>> indexStubTree() {
        HashMap<StubIndexKey, Map<Object, TIntArrayList>> result = new HashMap<StubIndexKey, Map<Object, TIntArrayList>>();
        SerializationManager serializationManager = SerializationManager.getInstance();
        StubIndexSink sink = new StubIndexSink(result);
        int plainListSize = this.myPlainList.size();
        for (int i = 0; i < plainListSize; ++i) {
            StubElement<?> stub = this.myPlainList.get(i);
            sink.myStubIdx = i;
            serializationManager.getSerializer(stub).indexStub(stub, sink);
        }
        HashMap<StubIndexKey, Map<Object, TIntArrayList>> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/StubTree.indexStubTree must not return null");
        }
        return hashMap;
    }

    private static class StubIndexSink
    implements IndexSink {
        private final Map<StubIndexKey, Map<Object, TIntArrayList>> myResult;
        private int myStubIdx;

        public StubIndexSink(Map<StubIndexKey, Map<Object, TIntArrayList>> result) {
            this.myResult = result;
        }

        public void occurrence(@NotNull StubIndexKey indexKey, @NotNull Object value) {
            TIntArrayList list;
            if (indexKey == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/StubTree$StubIndexSink.occurrence must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/stubs/StubTree$StubIndexSink.occurrence must not be null");
            }
            Map<Object, TIntArrayList> map = this.myResult.get(indexKey);
            if (map == null) {
                map = new THashMap<Object, TIntArrayList>();
                this.myResult.put(indexKey, map);
            }
            if ((list = map.get(value)) == null) {
                list = new TIntArrayList();
                map.put(value, list);
            }
            list.add(this.myStubIdx);
        }
    }
}

