/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.stubs;

import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.jet.internal.com.intellij.util.io.DataInputOutputUtil;
import org.jetbrains.jet.internal.com.intellij.util.io.DataOutputStream;
import org.jetbrains.jet.internal.com.intellij.util.io.IOUtil;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentStringEnumerator;

public class StubOutputStream
extends DataOutputStream {
    private final PersistentStringEnumerator myNameStorage;
    private final byte[] myStringIOBuffer = IOUtil.allocReadWriteUTFBuffer();

    public StubOutputStream(OutputStream out, PersistentStringEnumerator nameStorage) {
        super(out);
        this.myNameStorage = nameStorage;
    }

    public void writeUTFFast(String arg) throws IOException {
        IOUtil.writeUTFFast(this.myStringIOBuffer, this, arg);
    }

    public void writeName(String arg) throws IOException {
        DataInputOutputUtil.writeNAME(this, arg, this.myNameStorage);
    }

    public void writeVarInt(int value) throws IOException {
        DataInputOutputUtil.writeINT(this, value);
    }

    public int getStringId(String value) throws IOException {
        return this.myNameStorage.enumerate(value);
    }
}

