/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.stubs;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLock;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.internal.com.intellij.util.ArrayFactory;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public abstract class StubBase<T extends PsiElement>
extends UserDataHolderBase
implements StubElement<T> {
    private final StubElement myParent;
    private final List<StubElement> myChildren = new SmartList<StubElement>();
    private final IStubElementType myElementType;
    private volatile T myPsi;
    public int id;

    protected StubBase(StubElement parent, IStubElementType elementType) {
        this.myParent = parent;
        this.myElementType = elementType;
        if (parent != null) {
            ((StubBase)parent).myChildren.add(this);
        }
    }

    @Override
    public StubElement getParentStub() {
        return this.myParent;
    }

    @Override
    public List<StubElement> getChildrenStubs() {
        return this.myChildren;
    }

    @Override
    @Nullable
    public <P extends PsiElement> StubElement<P> findChildStubByType(IStubElementType<?, P> elementType) {
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int size = childrenStubs.size();
        for (int i = 0; i < size; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            return childStub;
        }
        return null;
    }

    public void setPsi(T psi) {
        this.myPsi = psi;
    }

    public T getCachedPsi() {
        return this.myPsi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getPsi() {
        Object psi = this.myPsi;
        if (psi != null) {
            return psi;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            psi = this.myPsi;
            if (psi != null) {
                return psi;
            }
            this.myPsi = psi = this.getStubType().createPsi(this);
        }
        return psi;
    }

    @Override
    public <E extends PsiElement> E[] getChildrenByType(IElementType elementType, E[] array) {
        int count = this.countChildren(elementType);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count, array);
        if (count == 0) {
            return array;
        }
        this.fillFilteredChildren(elementType, (PsiElement[])array);
        return array;
    }

    @Override
    public <E extends PsiElement> E[] getChildrenByType(TokenSet filter, E[] array) {
        int count = this.countChildren(filter);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count, array);
        if (count == 0) {
            return array;
        }
        this.fillFilteredChildren(filter, (PsiElement[])array);
        return array;
    }

    @Override
    public <E extends PsiElement> E[] getChildrenByType(IElementType elementType, ArrayFactory<E> f) {
        int count = this.countChildren(elementType);
        PsiElement[] result = (PsiElement[])f.create(count);
        if (count > 0) {
            this.fillFilteredChildren(elementType, result);
        }
        return result;
    }

    private int countChildren(IElementType elementType) {
        int count = 0;
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            ++count;
        }
        return count;
    }

    private int countChildren(TokenSet types) {
        int count = 0;
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (!types.contains(childStub.getStubType())) continue;
            ++count;
        }
        return count;
    }

    private <E extends PsiElement> void fillFilteredChildren(IElementType type, E[] result) {
        int count = 0;
        for (StubElement childStub : this.getChildrenStubs()) {
            if (childStub.getStubType() != type) continue;
            result[count++] = childStub.getPsi();
        }
        assert (count == result.length);
    }

    private <E extends PsiElement> void fillFilteredChildren(TokenSet set, E[] result) {
        int count = 0;
        for (StubElement childStub : this.getChildrenStubs()) {
            if (!set.contains(childStub.getStubType())) continue;
            result[count++] = childStub.getPsi();
        }
        assert (count == result.length);
    }

    @Override
    public <E extends PsiElement> E[] getChildrenByType(TokenSet filter, ArrayFactory<E> f) {
        int count = this.countChildren(filter);
        PsiElement[] array = (PsiElement[])f.create(count);
        if (count == 0) {
            return array;
        }
        this.fillFilteredChildren(filter, array);
        return array;
    }

    @Override
    @Nullable
    public <E extends PsiElement> E getParentStubOfType(Class<E> parentClass) {
        for (StubElement parent = this.myParent; parent != null; parent = parent.getParentStub()) {
            Object psi = parent.getPsi();
            if (!parentClass.isInstance(psi)) continue;
            return (E)psi;
        }
        return null;
    }

    @Override
    public IStubElementType getStubType() {
        return this.myElementType;
    }

    public Project getProject() {
        return this.getPsi().getProject();
    }

    public String printTree() {
        StringBuilder builder = new StringBuilder();
        this.printTree(builder, 0);
        return builder.toString();
    }

    private void printTree(StringBuilder builder, int nestingLevel) {
        for (int i = 0; i < nestingLevel; ++i) {
            builder.append("  ");
        }
        builder.append(this.toString()).append('\n');
        for (StubElement child : this.getChildrenStubs()) {
            ((StubBase)child).printTree(builder, nestingLevel + 1);
        }
    }
}

