/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.FileASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.LighterAST;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.LogUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Ref;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.StubBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.ILightStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.ILightStubFileElementType;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;
import org.jetbrains.jet.internal.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.jet.internal.com.intellij.util.containers.Stack;
import org.jetbrains.jet.internal.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.jet.internal.gnu.trove.TIntStack;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.LightStubBuilder");

    @Override
    public StubElement buildStubTree(PsiFile file) {
        LighterAST tree;
        FileType fileType = file.getFileType();
        if (!(fileType instanceof LanguageFileType)) {
            LOG.error("File is not of LanguageFileType: " + fileType + ", " + file);
            return null;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        IFileElementType contentType = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)).getFileNodeType();
        if (!(contentType instanceof ILightStubFileElementType)) {
            LOG.error("File is not of ILightStubFileElementType: " + contentType + ", " + file);
            return null;
        }
        FileASTNode node = file.getNode();
        assert (node != null) : file;
        if (!node.isParsed()) {
            ILightStubFileElementType type = (ILightStubFileElementType)contentType;
            tree = new FCTSBackedLighterAST(node.getCharTable(), type.parseContentsLight(node));
        } else {
            tree = new TreeBackedLighterAST(node);
        }
        StubElement rootStub = this.createStubForFile(file, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    protected StubElement createStubForFile(PsiFile file, LighterAST tree) {
        return new PsiFileStubImpl<PsiFile>(file);
    }

    protected void buildStubTree(LighterAST tree, LighterASTNode root, StubElement rootStub) {
        Stack<LighterASTNode> parents = new Stack<LighterASTNode>();
        TIntStack childNumbers = new TIntStack();
        Stack<List> kinderGarden = new Stack<List>();
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        LighterASTNode parent = null;
        LighterASTNode element = root;
        List children = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        block0: while (element != null) {
            List kids;
            StubElement stub = this.createStub(tree, element, parentStub);
            if (!(parent != null && this.skipChildProcessingWhenBuildingStubs(this, tree, parent, element) || (kids = tree.getChildren(element)).isEmpty())) {
                if (parent != null) {
                    parents.push(parent);
                    childNumbers.push(childNumber);
                    kinderGarden.push(children);
                    parentStubs.push(parentStub);
                }
                parent = element;
                children = kids;
                childNumber = 0;
                element = children.get(0);
                parentStub = stub;
                if (!this.skipChildProcessingWhenBuildingStubs(parent.getTokenType(), element.getTokenType())) continue;
            }
            while (children != null && ++childNumber < children.size()) {
                element = children.get(childNumber);
                if (this.skipChildProcessingWhenBuildingStubs(parent.getTokenType(), element.getTokenType())) continue;
                continue block0;
            }
            element = null;
            while (!parents.isEmpty()) {
                parent = (LighterASTNode)parents.pop();
                childNumber = childNumbers.pop();
                children = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                while (++childNumber < children.size()) {
                    element = (LighterASTNode)children.get(childNumber);
                    if (this.skipChildProcessingWhenBuildingStubs(parent.getTokenType(), element.getTokenType())) continue;
                    continue block0;
                }
                element = null;
            }
        }
    }

    protected StubElement createStub(LighterAST tree, LighterASTNode element, StubElement parentStub) {
        IElementType elementType = element.getTokenType();
        if (elementType instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree, element, parentStub)) {
                    return lightElementType.createStub(tree, element, parentStub);
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + LogUtil.objectAndClass(elementType) + ", " + element);
            }
        }
        return parentStub;
    }

    @Override
    public final boolean skipChildProcessingWhenBuildingStubs(@Nullable ASTNode parent, IElementType childType) {
        return this.skipChildProcessingWhenBuildingStubs(parent != null ? parent.getElementType() : null, childType);
    }

    public boolean skipChildProcessingWhenBuildingStubs(LightStubBuilder builder, LighterAST tree, LighterASTNode parent, LighterASTNode child) {
        return false;
    }

    public boolean skipChildProcessingWhenBuildingStubs(IElementType parent, IElementType childType) {
        return false;
    }

    private static class TreeBackedLighterAST
    extends LighterAST {
        private final FileASTNode myRoot;

        public TreeBackedLighterAST(FileASTNode root) {
            super(root.getCharTable());
            this.myRoot = root;
        }

        @Override
        @NotNull
        public LighterASTNode getRoot() {
            LighterASTNode lighterASTNode = TreeBackedLighterAST.wrap(this.myRoot);
            if (lighterASTNode == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST.getRoot must not return null");
            }
            return lighterASTNode;
        }

        @Override
        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST.getParent must not be null");
            }
            return TreeBackedLighterAST.wrap(((NodeWrapper)node).myNode.getTreeParent());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent) {
            List<LighterASTNode> list;
            if (parent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST.getChildren must not be null");
            }
            ASTNode[] children = ((NodeWrapper)parent).myNode.getChildren(null);
            if (children == null || children.length == 0) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST.getChildren must not return null");
                return list;
            }
            ArrayList<LighterASTNode> result = new ArrayList<LighterASTNode>(children.length);
            for (ASTNode child : children) {
                result.add(TreeBackedLighterAST.wrap(child));
            }
            list = result;
            if (list != null) return list;
            throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST.getChildren must not return null");
        }

        @Nullable
        private static LighterASTNode wrap(@Nullable ASTNode node) {
            if (node == null) {
                return null;
            }
            if (node.getFirstChildNode() == null && node.getTextLength() > 0) {
                return new TokenNodeWrapper(node);
            }
            return new NodeWrapper(node);
        }

        private static class TokenNodeWrapper
        extends NodeWrapper
        implements LighterASTTokenNode {
            public TokenNodeWrapper(ASTNode node) {
                super(node);
            }

            @Override
            public CharSequence getText() {
                return this.myNode.getText();
            }

            @Override
            public String toString() {
                return "token wrapper[" + this.myNode + "]";
            }
        }

        private static class NodeWrapper
        implements LighterASTNode {
            protected final ASTNode myNode;

            public NodeWrapper(ASTNode node) {
                this.myNode = node;
            }

            @Override
            public IElementType getTokenType() {
                return this.myNode.getElementType();
            }

            @Override
            public int getStartOffset() {
                return this.myNode.getStartOffset();
            }

            @Override
            public int getEndOffset() {
                return this.myNode.getStartOffset() + this.myNode.getTextLength();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof NodeWrapper)) {
                    return false;
                }
                NodeWrapper that = (NodeWrapper)o;
                return !(this.myNode != null ? !this.myNode.equals(that.myNode) : that.myNode != null);
            }

            public int hashCode() {
                return this.myNode.hashCode();
            }

            public String toString() {
                return "node wrapper[" + this.myNode + "]";
            }
        }
    }

    private static class FCTSBackedLighterAST
    extends LighterAST {
        private final FlyweightCapableTreeStructure<LighterASTNode> myTreeStructure;

        public FCTSBackedLighterAST(CharTable charTable, FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
            super(charTable);
            this.myTreeStructure = treeStructure;
        }

        @Override
        @NotNull
        public LighterASTNode getRoot() {
            LighterASTNode lighterASTNode = this.myTreeStructure.getRoot();
            if (lighterASTNode == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/LightStubBuilder$FCTSBackedLighterAST.getRoot must not return null");
            }
            return lighterASTNode;
        }

        @Override
        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/LightStubBuilder$FCTSBackedLighterAST.getParent must not be null");
            }
            return this.myTreeStructure.getParent(node);
        }

        @Override
        @NotNull
        public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/LightStubBuilder$FCTSBackedLighterAST.getChildren must not be null");
            }
            Ref<T[]> into = new Ref<T[]>();
            int numKids = this.myTreeStructure.getChildren(this.myTreeStructure.prepareForGetChildren(parent), into);
            List<LighterASTNode> list = numKids > 0 ? CollectionFactory.arrayList(into.get(), 0, numKids) : Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/LightStubBuilder$FCTSBackedLighterAST.getChildren must not return null");
            }
            return list;
        }
    }
}

