/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.stubs;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubSerializer;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public abstract class IStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    public IStubElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/IStubElementType.<init> must not be null");
        }
        super(debugName, language);
    }

    public abstract PsiT createPsi(@NotNull StubT var1);

    public abstract StubT createStub(@NotNull PsiT var1, StubElement var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    public String getId(StubT stub) {
        assert (stub.getStubType() == this);
        StubElement parent = stub.getParentStub();
        int count = 0;
        for (StubElement child : parent.getChildrenStubs()) {
            if (child.getStubType() == this) {
                ++count;
            }
            if (child != stub) continue;
            return '#' + String.valueOf(count);
        }
        throw new RuntimeException("Parent/child relations corrupted");
    }
}

