/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.stubs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.StubBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.containers.Stack;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.DefaultStubBuilder");

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/DefaultStubBuilder.buildStubTree must not be null");
        }
        return this.buildStubTreeFor(file, this.createStubForFile(file));
    }

    protected StubElement createStubForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/DefaultStubBuilder.createStubForFile must not be null");
        }
        return new PsiFileStubImpl<PsiFile>(file);
    }

    private StubElement buildStubTreeFor(@NotNull PsiElement root, @NotNull StubElement parentStub) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/DefaultStubBuilder.buildStubTreeFor must not be null");
        }
        if (parentStub == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/stubs/DefaultStubBuilder.buildStubTreeFor must not be null");
        }
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        Stack<PsiElement> parentElements = new Stack<PsiElement>();
        parentElements.push(root);
        parentStubs.push(parentStub);
        while (!parentElements.isEmpty()) {
            StubElement<Object> stub = (StubElement)parentStubs.pop();
            PsiElement elt = (PsiElement)parentElements.pop();
            if (elt instanceof StubBasedPsiElement) {
                IStubElementType type = ((StubBasedPsiElement)elt).getElementType();
                if (type.shouldCreateStub(elt.getNode())) {
                    stub = type.createStub(elt, stub);
                }
            } else {
                IElementType type;
                ASTNode node = elt.getNode();
                IElementType iElementType = type = node == null ? null : node.getElementType();
                if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(node)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + elt);
                }
            }
            for (PsiElement child = elt.getLastChild(); child != null; child = child.getPrevSibling()) {
                if (this.skipChildProcessingWhenBuildingStubs(elt, child)) continue;
                parentStubs.push(stub);
                parentElements.push(child);
            }
        }
        return parentStub;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull PsiElement element, @NotNull PsiElement child) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/DefaultStubBuilder.skipChildProcessingWhenBuildingStubs must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/stubs/DefaultStubBuilder.skipChildProcessingWhenBuildingStubs must not be null");
        }
        return false;
    }

    protected StubElement buildStubTreeFor(@NotNull ASTNode root, @NotNull StubElement parentStub) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/DefaultStubBuilder.buildStubTreeFor must not be null");
        }
        if (parentStub == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/stubs/DefaultStubBuilder.buildStubTreeFor must not be null");
        }
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        Stack<ASTNode> parentNodes = new Stack<ASTNode>();
        parentNodes.push(root);
        parentStubs.push(parentStub);
        while (!parentStubs.isEmpty()) {
            IStubElementType type;
            StubElement<Object> stub = (StubElement)parentStubs.pop();
            ASTNode node = (ASTNode)parentNodes.pop();
            IElementType nodeType = node.getElementType();
            if (nodeType instanceof IStubElementType && (type = (IStubElementType)nodeType).shouldCreateStub(node)) {
                PsiElement element = node.getPsi();
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + element);
                }
                LOG.assertTrue((stub = type.createStub(element, stub)) != null, element);
            }
            for (ASTNode childNode = node.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (this.skipChildProcessingWhenBuildingStubs(node, childNode.getElementType())) continue;
                parentNodes.push(childNode);
                parentStubs.push(stub);
            }
        }
        return parentStub;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@Nullable ASTNode parent, IElementType childType) {
        return false;
    }
}

