/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.stubs;

import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.BinaryFileStubBuilders;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubTree;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubTreeBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubTreeLoader;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.jet.internal.com.intellij.util.indexing.FileContentImpl;
import org.jetbrains.jet.internal.com.intellij.util.indexing.IndexingDataKeys;

public class CoreStubTreeLoader
extends StubTreeLoader {
    @Override
    public StubTree readOrBuild(Project project, VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (!this.canHaveStub(vFile)) {
            return null;
        }
        try {
            FileContentImpl fc = new FileContentImpl(vFile, vFile.contentsToByteArray());
            fc.putUserData(IndexingDataKeys.PROJECT, project);
            StubElement element = StubTreeBuilder.buildStubTree(fc);
            if (element instanceof PsiFileStub) {
                return new StubTree((PsiFileStub)element);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public StubTree readFromVFile(Project project, VirtualFile vFile) {
        return null;
    }

    @Override
    public void rebuildStubTree(VirtualFile virtualFile) {
    }

    @Override
    public long getStubTreeTimestamp(VirtualFile vFile) {
        return 0L;
    }

    @Override
    public boolean canHaveStub(VirtualFile file) {
        FileType fileType = file.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            return elementType instanceof IStubFileElementType && ((IStubFileElementType)elementType).shouldBuildStubFor(file);
        }
        if (fileType.isBinary()) {
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            return builder != null && builder.acceptsFile(file);
        }
        return false;
    }
}

