/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.search.searches;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.search.searches.ExtensibleQueryFactory;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.jet.internal.com.intellij.util.Query;

public class SuperMethodsSearch
extends ExtensibleQueryFactory<MethodSignatureBackedByPsiMethod, SearchParameters> {
    public static final SuperMethodsSearch SUPER_METHODS_SEARCH_INSTANCE = new SuperMethodsSearch();

    private SuperMethodsSearch() {
    }

    public static Query<MethodSignatureBackedByPsiMethod> search(PsiMethod derivedMethod, @Nullable PsiClass psiClass, boolean checkBases, boolean allowStaticMethod) {
        SearchParameters parameters = new SearchParameters(derivedMethod, psiClass, checkBases, allowStaticMethod);
        return SUPER_METHODS_SEARCH_INSTANCE.createUniqueResultsQuery(parameters, MethodSignatureUtil.METHOD_BASED_HASHING_STRATEGY);
    }

    public static class SearchParameters {
        private final PsiMethod myMethod;
        @Nullable
        private final PsiClass myClass;
        private final boolean myCheckBases;
        private final boolean myAllowStaticMethod;

        public SearchParameters(PsiMethod method, @Nullable PsiClass aClass, boolean checkBases, boolean allowStaticMethod) {
            this.myCheckBases = checkBases;
            this.myClass = aClass;
            this.myMethod = method;
            this.myAllowStaticMethod = allowStaticMethod;
        }

        public final boolean isCheckBases() {
            return this.myCheckBases;
        }

        public final PsiMethod getMethod() {
            return this.myMethod;
        }

        @Nullable
        public final PsiClass getPsiClass() {
            return this.myClass;
        }

        public final boolean isAllowStaticMethod() {
            return this.myAllowStaticMethod;
        }
    }
}

