/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.search;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;

public class PsiSearchScopeUtil {
    @Nullable
    public static SearchScope union(@Nullable SearchScope a, @Nullable SearchScope b) {
        return a == null ? b : (b == null ? a : a.union(b));
    }

    @Deprecated
    @NotNull
    public static SearchScope scopesUnion(@NotNull SearchScope scope1, @NotNull SearchScope scope2) {
        if (scope1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiSearchScopeUtil.scopesUnion must not be null");
        }
        if (scope2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/PsiSearchScopeUtil.scopesUnion must not be null");
        }
        SearchScope searchScope = scope1.union(scope2);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/PsiSearchScopeUtil.scopesUnion must not return null");
        }
        return searchScope;
    }

    public static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiElement element) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiSearchScopeUtil.isInScope must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/PsiSearchScopeUtil.isInScope must not be null");
        }
        if (scope instanceof LocalSearchScope) {
            LocalSearchScope local = (LocalSearchScope)scope;
            return PsiSearchScopeUtil.isInScope(local, element);
        }
        GlobalSearchScope globalScope = (GlobalSearchScope)scope;
        return PsiSearchScopeUtil.isInScope(globalScope, element);
    }

    public static boolean isInScope(@NotNull GlobalSearchScope globalScope, @NotNull PsiElement element) {
        if (globalScope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiSearchScopeUtil.isInScope must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/PsiSearchScopeUtil.isInScope must not be null");
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return true;
        }
        PsiElement context = file.getContext();
        if (context != null) {
            file = context.getContainingFile();
        }
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile == null || globalScope.contains(file.getVirtualFile());
    }

    public static boolean isInScope(@NotNull LocalSearchScope local, @NotNull PsiElement element) {
        PsiElement[] scopeElements;
        if (local == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiSearchScopeUtil.isInScope must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/PsiSearchScopeUtil.isInScope must not be null");
        }
        for (PsiElement scopeElement : scopeElements = local.getScope()) {
            if (!PsiTreeUtil.isAncestor(scopeElement, element, false)) continue;
            return true;
        }
        return false;
    }
}

