/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.search;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.module.Module;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;

public class DelegatingGlobalSearchScope
extends GlobalSearchScope {
    protected final GlobalSearchScope myBaseScope;
    private final Object myEquality;

    public DelegatingGlobalSearchScope(@NotNull GlobalSearchScope baseScope) {
        if (baseScope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/DelegatingGlobalSearchScope.<init> must not be null");
        }
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myEquality = new Object();
    }

    public DelegatingGlobalSearchScope(GlobalSearchScope baseScope, Object ... equality) {
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myEquality = Arrays.asList(equality);
    }

    @Override
    public boolean contains(VirtualFile file) {
        return this.myBaseScope.contains(file);
    }

    @Override
    public int compare(VirtualFile file1, VirtualFile file2) {
        return this.myBaseScope.compare(file1, file2);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/DelegatingGlobalSearchScope.isSearchInModuleContent must not be null");
        }
        return this.myBaseScope.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/DelegatingGlobalSearchScope.isSearchInModuleContent must not be null");
        }
        return this.myBaseScope.isSearchInModuleContent(aModule, testSources);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myBaseScope.isSearchInLibraries();
    }

    @Override
    public boolean isSearchOutsideRootModel() {
        return this.myBaseScope.isSearchOutsideRootModel();
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/DelegatingGlobalSearchScope.intersectWith must not be null");
        }
        GlobalSearchScope globalSearchScope = super.intersectWith(scope);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/DelegatingGlobalSearchScope.intersectWith must not return null");
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/DelegatingGlobalSearchScope.intersectWith must not be null");
        }
        SearchScope searchScope = super.intersectWith(scope2);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/DelegatingGlobalSearchScope.intersectWith must not return null");
        }
        return searchScope;
    }

    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull LocalSearchScope localScope2) {
        if (localScope2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/DelegatingGlobalSearchScope.intersectWith must not be null");
        }
        SearchScope searchScope = super.intersectWith(localScope2);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/DelegatingGlobalSearchScope.intersectWith must not return null");
        }
        return searchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/DelegatingGlobalSearchScope.union must not be null");
        }
        GlobalSearchScope globalSearchScope = super.union(scope);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/DelegatingGlobalSearchScope.union must not return null");
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope union(@NotNull LocalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/DelegatingGlobalSearchScope.union must not be null");
        }
        GlobalSearchScope globalSearchScope = super.union(scope);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/DelegatingGlobalSearchScope.union must not return null");
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/DelegatingGlobalSearchScope.uniteWith must not be null");
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/DelegatingGlobalSearchScope.uniteWith must not return null");
        }
        return globalSearchScope;
    }

    @Override
    public String getDisplayName() {
        return this.myBaseScope.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingGlobalSearchScope that = (DelegatingGlobalSearchScope)o;
        if (!this.myBaseScope.equals(that.myBaseScope)) {
            return false;
        }
        return this.myEquality.equals(that.myEquality);
    }

    @Override
    public int hashCode() {
        int result = this.myBaseScope.hashCode();
        result = 31 * result + this.myEquality.hashCode();
        return result;
    }
}

