/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.scope.processor;

import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.ConflictFilterProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public abstract class MethodsProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.METHOD;
    private boolean myStaticScopeFlag = false;
    private boolean myIsConstructor = false;
    protected PsiElement myCurrentFileContext = null;
    protected PsiClass myAccessClass = null;
    private PsiExpressionList myArgumentList;
    private PsiType[] myTypeArguments;
    private LanguageLevel myLanguageLevel;

    public MethodsProcessor(PsiConflictResolver[] resolvers, SmartList<CandidateInfo> container, PsiElement place) {
        super(null, ourFilter, resolvers, container, place);
    }

    public PsiExpressionList getArgumentList() {
        return this.myArgumentList;
    }

    public void setArgumentList(PsiExpressionList argList) {
        this.myArgumentList = argList;
        this.myLanguageLevel = PsiUtil.getLanguageLevel(this.myArgumentList);
    }

    protected LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public void obtainTypeArguments(PsiCallExpression callExpression) {
        PsiType[] typeArguments = callExpression.getTypeArguments();
        if (typeArguments.length > 0) {
            this.setTypeArguments(typeArguments);
        }
    }

    protected void setTypeArguments(PsiType[] typeParameters) {
        this.myTypeArguments = typeParameters;
    }

    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    public boolean isInStaticScope() {
        return this.myStaticScopeFlag;
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    public void setAccessClass(PsiClass accessClass) {
        this.myAccessClass = accessClass;
    }

    public boolean isConstructor() {
        return this.myIsConstructor;
    }

    public void setIsConstructor(boolean myIsConstructor) {
        this.myIsConstructor = myIsConstructor;
    }

    public void forceAddResult(PsiMethod method) {
        this.add(new CandidateInfo(method, PsiSubstitutor.EMPTY, false, false, this.myCurrentFileContext));
    }

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.METHOD;
    }
}

