/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.scope.processor;

import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public class MethodResolverProcessor
extends MethodCandidatesProcessor {
    private boolean myStopAcceptingCandidates = false;

    public MethodResolverProcessor(PsiMethodCallExpression place) {
        this(place, new PsiConflictResolver[]{new JavaMethodsConflictResolver(place.getArgumentList())});
        this.setArgumentList(place.getArgumentList());
        this.obtainTypeArguments(place);
    }

    public MethodResolverProcessor(PsiClass classConstr, PsiExpressionList argumentList, PsiElement place) {
        super(place, new PsiConflictResolver[]{new JavaMethodsConflictResolver(argumentList)}, new SmartList<CandidateInfo>());
        this.setIsConstructor(true);
        this.setAccessClass(classConstr);
        this.setArgumentList(argumentList);
    }

    public MethodResolverProcessor(PsiElement place, PsiConflictResolver[] resolvers) {
        super(place, resolvers, new SmartList<CandidateInfo>());
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myHasAccessibleStaticCorrectCandidate) {
            this.myStopAcceptingCandidates = true;
        }
        super.handleEvent(event, associated);
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        return !this.myStopAcceptingCandidates && super.execute(element, state);
    }
}

